/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.instrumentation;

import java.util.Set;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.instrumentation.RIMBean;
import org.gcube.common.core.scope.GCUBEScope;

public class RI
implements RIMBean {
    private GCUBEServiceContext ctxt;
    private long callCount;
    private long failedCallCount;
    private float lastResponseTime;
    private float totalWorkTime;

    public RI(GCUBEServiceContext ctxt) {
        this.ctxt = ctxt;
    }

    @Override
    public String getServiceClass() {
        return this.ctxt.getServiceClass();
    }

    @Override
    public String getServiceName() {
        return this.ctxt.getName();
    }

    @Override
    public String getStatus() {
        return this.ctxt.getStatus().toString();
    }

    @Override
    public String getScope() {
        return this.ctxt.getInstance().getScopes().values().toString();
    }

    @Override
    public String addScope(String s) throws Exception {
        Set<GCUBEScope> scopes = this.ctxt.addScope(GCUBEScope.getScope(s));
        return (scopes.size() > 0 ? scopes.iterator().next() : "no scope") + " was added to the Running Instance";
    }

    @Override
    public String removeScope(String s) throws Exception {
        GCUBEScope scope = GCUBEScope.getScope(s);
        Set<GCUBEScope> scopes = this.ctxt.removeScope(scope);
        return (scopes.size() > 0 ? scopes.iterator().next() : "no scope") + " was removed from the Running Instance";
    }

    @Override
    public synchronized long getCallCount() {
        return this.callCount;
    }

    public synchronized void addCall() {
        ++this.callCount;
    }

    @Override
    public synchronized float getAverageResponseTime() {
        return this.callCount > 0L && this.totalWorkTime > 0.0f ? this.totalWorkTime / (float)this.callCount : 0.0f;
    }

    @Override
    public synchronized float getLastResponseTime() {
        return this.lastResponseTime;
    }

    public synchronized void setLastResponseTime(float time) {
        this.lastResponseTime = time;
        this.totalWorkTime += time;
    }

    @Override
    public synchronized long getFailedCalls() {
        return this.failedCallCount;
    }

    public synchronized void addFailedCall() {
        ++this.failedCallCount;
    }
}

