/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.ghnmanager.impl.contexts;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.contexts.ghn.Events;
import org.gcube.common.core.contexts.ghn.GHNConsumer;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.QueryParameter;
import org.gcube.common.core.informationsystem.client.XMLResult;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGHNQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericQuery;
import org.gcube.common.core.informationsystem.publisher.ISPublisher;
import org.gcube.common.core.resources.GCUBEHostingNode;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.resources.common.PlatformDescription;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.core.utils.handlers.GCUBEScheduledHandler;
import org.gcube.common.vremanagement.ghnmanager.impl.platforms.PlatformMonitor;

public class ServiceContext
extends GCUBEServiceContext {
    public static final String JNDI_NAME = "gcube/common/vremanagement/ghnmanager";
    protected static ServiceContext context = new ServiceContext();
    private boolean starting = true;
    private ISClient client;
    private ISPublisher publisher;

    private ServiceContext() {
    }

    public static ServiceContext getContext() {
        return context;
    }

    protected void onInitialisation() throws Exception {
        try {
            this.client = (ISClient)GHNContext.getImplementation(ISClient.class);
            this.publisher = (ISPublisher)GHNContext.getImplementation(ISPublisher.class);
            this.completeGHNProfile();
        }
        catch (Exception e) {
            throw new RuntimeException("unable to find the IS*.class implementation");
        }
        GHNConsumer sManager = new GHNConsumer(){

            protected void onGHNUpdated(Events.GHNLifeTimeEvent event) {
                GHNContext context = GHNContext.getContext();
                ServiceContext.this.logger.debug((Object)(((Events.GHNTopic)event.getTopic()).name() + " event received"));
                ISPublisher publisher = null;
                try {
                    publisher = (ISPublisher)GHNContext.getImplementation(ISPublisher.class);
                }
                catch (Exception e1) {
                    ServiceContext.this.logger.fatal((Object)"Unable to find a valid ISPublisher implementation");
                    throw new RuntimeException();
                }
                try {
                    if (context.getGHN().getScopes().values().size() == 0) {
                        ServiceContext.this.logger.fatal((Object)"No scope found in the GHN");
                    }
                    for (GCUBEScope scope : context.getGHN().getScopes().values()) {
                        if (scope == null || scope.toString().compareToIgnoreCase("null") == 0 || scope.getType() == GCUBEScope.Type.VRE) continue;
                        ServiceContext.this.logger.debug((Object)("Publishing GHN profile in scope " + scope));
                        try {
                            if (context.getMode() == GHNContext.Mode.STANDALONE) continue;
                            if (ServiceContext.this.isStarting()) {
                                publisher.registerGCUBEResource((GCUBEResource)context.getGHN(), scope, (GCUBESecurityManager)ServiceContext.this);
                                continue;
                            }
                            publisher.updateGCUBEResource((GCUBEResource)context.getGHN(), scope, (GCUBESecurityManager)ServiceContext.this);
                        }
                        catch (Exception e) {
                            ServiceContext.this.logger.error((Object)("Unable to publish GHN profile in " + scope.getName()), (Throwable)e);
                            StringWriter writer = new StringWriter();
                            context.getGHN().store((Writer)writer);
                            ServiceContext.this.logger.debug((Object)writer);
                        }
                    }
                }
                catch (Exception e) {
                    ServiceContext.this.logger.error((Object)"Unable to publish GHN profile", (Throwable)e);
                }
            }
        };
        GHNContext.getContext().subscribeGHNEvents(sManager, new Events.GHNTopic[]{Events.GHNTopic.UPDATE});
        this.setStarted();
    }

    private void completeGHNProfile() {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        executor.scheduleAtFixedRate(new PlatformMonitor(), 0L, 120L, TimeUnit.SECONDS);
    }

    public String getJNDIName() {
        return JNDI_NAME;
    }

    protected void onReady() throws Exception {
        super.onReady();
        HCleanupScheduler cleanupScheduler = new HCleanupScheduler(10L, GCUBEScheduledHandler.Mode.LAZY);
        HCleanup c = new HCleanup();
        c.setHandled((Object)this);
        cleanupScheduler.setScheduled(c);
        cleanupScheduler.run();
    }

    protected boolean isStarting() {
        return this.starting;
    }

    private void setStarted() {
        this.starting = false;
    }

    public List<PlatformDescription> getConfiguredPlatforms() {
        return Collections.unmodifiableList(GHNContext.getContext().getGHN().getNodeDescription().getAvailablePlatforms());
    }

    protected class HCleanupScheduler
    extends GCUBEScheduledHandler {
        public HCleanupScheduler(long interval, GCUBEScheduledHandler.Mode mode) {
            super(interval, mode, new GCUBEHandler[0]);
        }

        protected boolean repeat(Exception exception, int exceptionCount) {
            if (exception != null) {
                if (exceptionCount >= 20) {
                    this.logger.warn((Object)"Max attempts reached, no more chance to cleanup the GHN");
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    protected class HCleanup
    extends GCUBEHandler<ServiceContext> {
        protected HCleanup() {
        }

        public void run() throws Exception {
            if (GHNContext.getContext().getMode() == GHNContext.Mode.STANDALONE) {
                return;
            }
            if (!GHNContext.getContext().isGHNReady()) {
                throw new Exception();
            }
            ((ServiceContext)((Object)this.getHandled())).logger.debug((Object)"Checking the GHN profiles on the IS");
            GCUBEHostingNode ghnProfile = GHNContext.getContext().getGHN();
            GCUBEGHNQuery node = (GCUBEGHNQuery)ServiceContext.this.client.getQuery(GCUBEGHNQuery.class);
            node.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/Profile/GHNDescription/Name", ghnProfile.getNodeDescription().getName())});
            for (GCUBEScope scope : ((ServiceContext)((Object)this.getHandled())).getInstance().getScopes().values()) {
                List ghnList = ServiceContext.this.client.execute((ISQuery)node, scope);
                if (ghnList == null || ghnList.size() == 0) {
                    throw new Exception("no GHN registered on the IS yet");
                }
                if (ghnList.size() == 1 && ((GCUBEHostingNode)ghnList.get(0)).getID().compareToIgnoreCase(ghnProfile.getID()) == 0) continue;
                for (GCUBEHostingNode otherNode : ghnList) {
                    if (otherNode.getID().compareToIgnoreCase(ghnProfile.getID()) == 0) continue;
                    ((ServiceContext)((Object)this.getHandled())).logger.info((Object)("Deleting old GHN " + otherNode.getID() + " from scope " + scope));
                    ServiceContext.this.publisher.removeGCUBEResource(otherNode.getID(), "GHN", scope, (GCUBESecurityManager)ServiceContext.this);
                }
            }
            ((ServiceContext)((Object)this.getHandled())).logger.debug((Object)"Checking the running instance profiles on the IS");
            Set gCubeRIs = GHNContext.getContext().getServiceContexts();
            Collection vpRIs = GHNContext.getContext().getLocalInstanceContext().getAllInstances();
            if (gCubeRIs.size() == 0) {
                throw new Exception("no Service registered on the GHN yet");
            }
            GCUBEGenericQuery query = ServiceContext.this.client.getQuery("RIOnGHN");
            query.addParameters(new QueryParameter[]{new QueryParameter("ID", ghnProfile.getID())});
            for (GCUBEScope scope : ((ServiceContext)((Object)this.getHandled())).getInstance().getScopes().values()) {
                List results = ServiceContext.this.client.execute((ISQuery)query, scope);
                if (results == null) {
                    throw new Exception("no RI registered on the IS yet");
                }
                block3: for (XMLResult xml : results) {
                    String riid = (String)xml.evaluate("/Resource/ID/text()").get(0);
                    for (GCUBEServiceContext service : gCubeRIs) {
                        if (service.getInstance().getID().compareToIgnoreCase(riid) != 0) continue;
                        continue block3;
                    }
                    for (GCUBERunningInstance ri : vpRIs) {
                        if (ri.getID().compareToIgnoreCase(riid) != 0) continue;
                        continue block3;
                    }
                    ServiceContext.this.setScope(scope);
                    ServiceContext.this.logger.info((Object)("Deleting old RI " + riid + " from scope " + scope));
                    ServiceContext.this.publisher.removeGCUBEResource(riid, "RunningInstance", scope, (GCUBESecurityManager)ServiceContext.this);
                }
            }
        }
    }
}

