/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import com.ibm.icu.text.Normalizer;
import java.io.IOException;
import java.io.Writer;
import nu.xom.UnavailableCharacterException;

abstract class TextWriter {
    protected Writer out;
    protected String encoding;
    private String lineSeparator = "\r\n";
    private boolean lineSeparatorSet = false;
    private int maxLength = 0;
    private int indent = 0;
    private String indentString = "";
    private int column = 0;
    private boolean preserveSpace = false;
    private boolean normalize = false;
    private boolean lastCharacterWasSpace = false;
    private boolean skipFollowingLinefeed = false;
    private int highSurrogate;
    private boolean justBroke = false;
    private int fakeIndents = 0;

    protected TextWriter(Writer writer, String string) {
        this.out = writer;
        this.encoding = string;
    }

    void reset() {
        this.column = 0;
        this.fakeIndents = 0;
        this.lastCharacterWasSpace = false;
        this.skipFollowingLinefeed = false;
    }

    private boolean isHighSurrogate(int n) {
        return n >= 55296 && n <= 56319;
    }

    private boolean isLowSurrogate(int n) {
        return n >= 56320 && n <= 57343;
    }

    final void writePCDATA(char c) throws IOException {
        if (this.needsEscaping(c)) {
            if (this.isHighSurrogate(c)) {
                this.highSurrogate = c;
            } else if (this.isLowSurrogate(c)) {
                int n = this.highSurrogate & 0x7FF;
                int n2 = c - 56320;
                int n3 = n << 10;
                int n4 = n3 | n2;
                int n5 = n4 + 65536;
                String string = "&#x" + Integer.toHexString(n5).toUpperCase() + ';';
                this.out.write(string);
                this.column += string.length();
                this.lastCharacterWasSpace = false;
                this.skipFollowingLinefeed = false;
                this.justBroke = false;
            } else {
                String string = "&#x" + Integer.toHexString(c).toUpperCase() + ';';
                this.out.write(string);
                this.column += string.length();
                this.lastCharacterWasSpace = false;
                this.skipFollowingLinefeed = false;
                this.justBroke = false;
            }
        } else if (c == '&') {
            this.out.write("&amp;");
            this.column += 5;
            this.lastCharacterWasSpace = false;
            this.skipFollowingLinefeed = false;
            this.justBroke = false;
        } else if (c == '<') {
            this.out.write("&lt;");
            this.column += 4;
            this.lastCharacterWasSpace = false;
            this.skipFollowingLinefeed = false;
            this.justBroke = false;
        } else if (c == '>') {
            this.out.write("&gt;");
            this.column += 4;
            this.lastCharacterWasSpace = false;
            this.skipFollowingLinefeed = false;
            this.justBroke = false;
        } else if (c == '\r') {
            if (!this.adjustingWhiteSpace() && !this.lineSeparatorSet) {
                this.out.write("&#x0D;");
                this.column += 6;
                this.justBroke = false;
            } else if (!this.adjustingWhiteSpace() && this.lineSeparatorSet) {
                this.escapeBreakLine();
            } else {
                this.breakLine();
                this.lastCharacterWasSpace = true;
            }
            this.skipFollowingLinefeed = true;
        } else {
            this.write(c);
        }
    }

    private boolean adjustingWhiteSpace() {
        return this.maxLength > 0 || this.indent > 0;
    }

    final void writeAttributeValue(char c) throws IOException {
        if (this.needsEscaping(c)) {
            if (this.isHighSurrogate(c)) {
                this.highSurrogate = c;
            } else if (this.isLowSurrogate(c)) {
                int n = this.highSurrogate & 0x7FF;
                int n2 = c - 56320;
                int n3 = n << 10;
                int n4 = n3 | n2;
                int n5 = n4 + 65536;
                String string = "&#x" + Integer.toHexString(n5).toUpperCase() + ';';
                this.out.write(string);
                this.column += string.length();
                this.lastCharacterWasSpace = false;
                this.skipFollowingLinefeed = false;
                this.justBroke = false;
            } else {
                String string = "&#x" + Integer.toHexString(c).toUpperCase() + ';';
                this.out.write(string);
                this.column += string.length();
                this.lastCharacterWasSpace = false;
                this.skipFollowingLinefeed = false;
                this.justBroke = false;
            }
        } else if (c == '\t' && !this.adjustingWhiteSpace()) {
            this.out.write("&#x09;");
            this.column += 6;
            this.lastCharacterWasSpace = true;
            this.skipFollowingLinefeed = false;
            this.justBroke = false;
        } else if (c == '\n') {
            if (this.skipFollowingLinefeed) {
                this.skipFollowingLinefeed = false;
                return;
            }
            if (this.adjustingWhiteSpace()) {
                this.out.write(" ");
                this.lastCharacterWasSpace = true;
                this.justBroke = false;
            } else {
                if (this.lineSeparatorSet) {
                    this.escapeBreakLine();
                } else {
                    this.out.write("&#x0A;");
                    this.column += 6;
                    this.justBroke = false;
                }
                this.lastCharacterWasSpace = true;
            }
        } else if (c == '\"') {
            this.out.write("&quot;");
            this.column += 6;
            this.lastCharacterWasSpace = false;
            this.skipFollowingLinefeed = false;
            this.justBroke = false;
        } else if (c == '\r') {
            if (this.adjustingWhiteSpace()) {
                this.out.write(" ");
                this.lastCharacterWasSpace = true;
                this.skipFollowingLinefeed = true;
                this.justBroke = false;
            } else {
                if (this.lineSeparatorSet) {
                    this.escapeBreakLine();
                } else {
                    this.out.write("&#x0D;");
                    this.column += 6;
                    this.justBroke = false;
                }
                this.skipFollowingLinefeed = true;
            }
        } else if (c == '&') {
            this.out.write("&amp;");
            this.column += 5;
            this.lastCharacterWasSpace = false;
            this.skipFollowingLinefeed = false;
            this.justBroke = false;
        } else if (c == '<') {
            this.out.write("&lt;");
            this.column += 4;
            this.lastCharacterWasSpace = false;
            this.skipFollowingLinefeed = false;
            this.justBroke = false;
        } else if (c == '>') {
            this.out.write("&gt;");
            this.column += 4;
            this.lastCharacterWasSpace = false;
            this.skipFollowingLinefeed = false;
            this.justBroke = false;
        } else {
            this.write(c);
        }
    }

    private void write(char c) throws IOException {
        if (c == ' ' || c == '\n' || c == '\t') {
            if (this.needsBreak()) {
                this.breakLine();
                this.skipFollowingLinefeed = false;
            } else if (this.preserveSpace || this.indent <= 0 && this.maxLength <= 0) {
                if (c == ' ' || c == '\t') {
                    this.out.write(c);
                    this.skipFollowingLinefeed = false;
                    ++this.column;
                    this.justBroke = false;
                } else {
                    if (!this.lineSeparatorSet || !this.skipFollowingLinefeed) {
                        this.writeLineSeparator(c);
                    }
                    this.skipFollowingLinefeed = false;
                    this.column = 0;
                }
            } else if (!this.lastCharacterWasSpace) {
                this.out.write(32);
                ++this.column;
                this.skipFollowingLinefeed = false;
                this.justBroke = false;
            }
            this.lastCharacterWasSpace = true;
        } else {
            this.out.write(c);
            if (c < '\ud800' || c > '\udbff') {
                ++this.column;
            }
            this.lastCharacterWasSpace = false;
            this.skipFollowingLinefeed = false;
            this.justBroke = false;
        }
    }

    private void writeLineSeparator(char c) throws IOException {
        if (!this.lineSeparatorSet || this.preserveSpace) {
            this.out.write(c);
        } else if (this.lineSeparator.equals("\r\n")) {
            this.out.write("\r\n");
        } else if (this.lineSeparator.equals("\n")) {
            this.out.write(10);
        } else {
            this.out.write(13);
        }
    }

    private boolean needsBreak() {
        if (this.maxLength <= 0 || this.preserveSpace) {
            return false;
        }
        return this.column >= this.maxLength - 10;
    }

    boolean justBroke() {
        return this.justBroke;
    }

    final void breakLine() throws IOException {
        this.out.write(this.lineSeparator);
        this.out.write(this.indentString);
        this.column = this.indentString.length();
        this.lastCharacterWasSpace = true;
        this.justBroke = true;
    }

    final void escapeBreakLine() throws IOException {
        if ("\n".equals(this.lineSeparator)) {
            this.out.write("&#x0A;");
            this.column += 6;
        } else if ("\r\n".equals(this.lineSeparator)) {
            this.out.write("&#x0D;&#x0A;");
            this.column += 12;
        } else {
            this.out.write("&#x0D;");
            this.column += 6;
        }
        this.lastCharacterWasSpace = true;
    }

    protected final void writeMarkup(char c) throws IOException {
        if (this.needsEscaping(c)) {
            throw new UnavailableCharacterException(c, this.encoding);
        }
        this.write(c);
    }

    final void writePCDATA(String string) throws IOException {
        if (this.normalize) {
            string = Normalizer.normalize((String)string, (Normalizer.Mode)Normalizer.NFC);
        }
        for (int i = 0; i < string.length(); ++i) {
            this.writePCDATA(string.charAt(i));
        }
    }

    final void writeAttributeValue(String string) throws IOException {
        if (this.normalize) {
            string = Normalizer.normalize((String)string, (Normalizer.Mode)Normalizer.NFC);
        }
        for (int i = 0; i < string.length(); ++i) {
            this.writeAttributeValue(string.charAt(i));
        }
    }

    final void writeMarkup(String string) throws IOException {
        if (this.normalize) {
            string = Normalizer.normalize((String)string, (Normalizer.Mode)Normalizer.NFC);
        }
        for (int i = 0; i < string.length(); ++i) {
            this.writeMarkup(string.charAt(i));
        }
    }

    boolean isIndenting() {
        return this.indentString.length() > 0;
    }

    void incrementIndent() {
        StringBuffer stringBuffer = new StringBuffer(this.indentString);
        for (int i = 0; i < this.indent; ++i) {
            stringBuffer.append(' ');
        }
        if (this.maxLength > 0 && stringBuffer.length() > this.maxLength / 2) {
            ++this.fakeIndents;
        } else {
            this.indentString = stringBuffer.toString();
        }
    }

    void decrementIndent() {
        if (this.fakeIndents > 0) {
            --this.fakeIndents;
        } else {
            this.indentString = this.indentString.substring(0, this.indentString.length() - this.indent);
        }
    }

    String getEncoding() {
        return this.encoding;
    }

    String getLineSeparator() {
        return this.lineSeparator;
    }

    void setLineSeparator(String string) {
        if (!(string.equals("\n") || string.equals("\r") || string.equals("\r\n"))) {
            throw new IllegalArgumentException("Illegal Line Separator");
        }
        this.lineSeparator = string;
        this.lineSeparatorSet = true;
    }

    int getIndent() {
        return this.indent;
    }

    int getMaxLength() {
        return this.maxLength;
    }

    void setMaxLength(int n) {
        if (n < 0) {
            n = 0;
        }
        this.maxLength = n;
    }

    void setIndent(int n) {
        this.indent = n;
    }

    void flush() throws IOException {
        this.out.flush();
    }

    abstract boolean needsEscaping(char var1);

    boolean isPreserveSpace() {
        return this.preserveSpace;
    }

    void setPreserveSpace(boolean bl) {
        this.preserveSpace = bl;
    }

    int getColumnNumber() {
        return this.column;
    }

    void setNFC(boolean bl) {
        this.normalize = bl;
    }

    boolean getNFC() {
        return this.normalize;
    }
}

