/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.persistence;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.gcube.common.core.persistence.GCUBEPersistenceDelegate;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEResourceHome;
import org.gcube.common.core.state.GCUBEStatefulResource;
import org.globus.wsrf.NoSuchResourceException;

public abstract class GCUBEFilePersistenceDelegate<RESOURCEID, RESOURCE extends GCUBEStatefulResource<RESOURCEID>>
extends GCUBEPersistenceDelegate<RESOURCEID, RESOURCE> {
    private File storageRoot;

    protected File getStorageRoot() {
        return this.storageRoot;
    }

    @Override
    public synchronized void initialise(GCUBEResourceHome<? super RESOURCEID, RESOURCEID, RESOURCE> home) throws Exception {
        super.initialise(home);
        Class<?> resourceClass = this.getClass().getClassLoader().loadClass(home.getResourceClass());
        this.storageRoot = home.getServiceContext().getPersistentFile(resourceClass.getSimpleName(), new boolean[0]);
        this.storageRoot.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onLoad(RESOURCE resource, boolean firstLoad) throws Exception {
        File file = this.getFileFromResource(resource);
        if (!file.exists()) {
            throw new NoSuchResourceException();
        }
        FileInputStream fis = new FileInputStream(file);
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(fis);
            this.onLoad(resource, ois);
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (Exception e) {
                this.logger.warn("Could not close stream on resource file deserialisation");
            }
        }
    }

    @Override
    protected void onStore(RESOURCE resource) throws Exception {
        File tmpFile = null;
        ObjectOutputStream oos = null;
        try {
            tmpFile = File.createTempFile("resource", ".tmp", this.getStorageRoot());
            FileOutputStream fos = new FileOutputStream(tmpFile);
            oos = new ObjectOutputStream(fos);
            this.onStore(resource, oos);
            oos.flush();
            fos.getFD().sync();
            File file = this.getFileFromResource(resource);
            if (!tmpFile.renameTo(file)) {
                throw new Exception("Could not rename temporary serialisation file for " + resource.getClass().getSimpleName() + "(" + ((GCUBEStatefulResource)resource).getID() + ")");
            }
        }
        catch (Exception e) {
            if (tmpFile != null) {
                tmpFile.delete();
            }
            throw e;
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (Exception e) {
                this.logger.warn("Could not close stream on resource file serialisation");
            }
        }
    }

    protected void onLoad(RESOURCE resource, ObjectInputStream stream) throws Exception {
        Map tasks = (Map)stream.readObject();
        for (Map.Entry e : tasks.entrySet()) {
            ((GCUBEStatefulResource)resource).getScheduledTasks().put((String)e.getKey(), new GCUBEStatefulResource.TaskContext(null, GCUBEScope.getScope((String)e.getValue())));
        }
    }

    protected void onStore(RESOURCE resource, ObjectOutputStream stream) throws Exception {
        HashMap<String, String> tasks = new HashMap<String, String>();
        for (Map.Entry<String, GCUBEStatefulResource.TaskContext> e : ((GCUBEStatefulResource)resource).getScheduledTasks().entrySet()) {
            tasks.put(e.getKey(), e.getValue().scope.toString());
        }
        stream.writeObject(tasks);
    }

    @Override
    protected void onRemove(RESOURCE resource) throws IOException {
        this.getFileFromResource(resource).delete();
    }

    @Override
    public synchronized Collection<RESOURCEID> getResourceIdentifiers() {
        HashSet<RESOURCEID> identifiers = new HashSet<RESOURCEID>();
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(GCUBEFilePersistenceDelegate.this.getSuffix());
            }
        };
        String[] resourceFiles = this.getStorageRoot().list(filter);
        if (resourceFiles != null) {
            for (String fileName : this.getStorageRoot().list(filter)) {
                identifiers.add(this.getIDFromFileName(fileName.substring(0, fileName.lastIndexOf(this.getSuffix()))));
            }
        }
        return identifiers;
    }

    protected abstract File getFileFromResource(RESOURCE var1);

    protected abstract String getSuffix();

    protected abstract RESOURCEID getIDFromFileName(String var1);
}

