/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.common.Version;
import org.globus.gram.Gram;
import org.globus.gram.GramException;
import org.globus.gram.GramJob;
import org.globus.gram.WaitingForCommitException;
import org.globus.io.gass.server.GassServer;
import org.globus.rsl.Binding;
import org.globus.rsl.Bindings;
import org.globus.rsl.NameOpValue;
import org.globus.rsl.RSLParser;
import org.globus.rsl.RslNode;
import org.globus.rsl.Value;
import org.globus.rsl.VarRef;
import org.globus.tools.BatchJobListener;
import org.globus.tools.InteractiveJobListener;
import org.globus.tools.JobListener;
import org.globus.tools.MultiJobListener;
import org.globus.util.deactivator.Deactivator;
import org.ietf.jgss.GSSException;

public class GlobusRun {
    private static Log logger = LogFactory.getLog((class$org$globus$tools$GlobusRun == null ? (class$org$globus$tools$GlobusRun = GlobusRun.class$("org.globus.tools.GlobusRun")) : class$org$globus$tools$GlobusRun).getName());
    private static final String message = "\nSyntax: java GlobusRun [options] [RSL String]\n        java GlobusRun -version\n        java GlobusRun -help\n\n\tOptions\n\t-help | -usage\n\t\tDisplay help.\n\t-v | -version\n\t\tDisplay version.\n\t-f <rsl filename> | -file <rsl filename>\n\t\tRead RSL from the local file <rsl filename>. The RSL\n\t\tmust be a single job request.\n\t-q | -quiet\n\t\tQuiet mode (do not print diagnostic messages)\n\t-o | -output-enable\n\t\tUse the GASS Server library to redirect standout output\n\t\tand standard error to globusrun. Implies -quiet.\n\t-s | -server\n\t\t$(GLOBUSRUN_GASS_URL) can be used to access files local\n\t\tto the submission machine via GASS. Implies \n\t\t-output-enable and -quiet.\n\t-w | -write-allow\n\t\tEnable the GASS Server library and allow writing to\n\t\tGASS URLs. Implies -server and -quiet.\n\t-r <resource manager> | -resource-manager <resource manager>\n\t\tSubmit the RSL job request to the specified resource \n\t\tmanager. A resource manager can be specified in the \n\t\tfollowing ways:  \n\t\t - host\n\t\t - host:port\n\t\t - host:port/service\n\t\t - host/service\n\t\t - host:/service\n\t\t - host::subject\n\t\t - host:port:subject\n\t\t - host/service:subject\n\t\t - host:/service:subject\n\t\t - host:port/service:subject\n\t\tFor those resource manager contacts which omit the port, \n\t\tservice or subject field the following defaults are used:\n\t\tport = 2119\n\t\tservice = jobmanager \n\t\tsubject = subject based on hostname\n\t\tThis is a required argument when submitting a single RSL\n\t\trequest.\n\t-k | -kill <job ID>\n\t\tKill a disconnected globusrun job.\n\t-status <job ID>\n\t\tPrint the current status of the specified job.\n\t-b | -batch\n\t\tCause globusrun to terminate after the job is successfully\n\t\tsubmitted, without waiting for its completion. Useful \n\t\tfor batch jobs. This option cannot be used together with \n\t\teither -server or -interactive, and is also incompatible \n\t\twith multi-request jobs. The \"handle\" or job ID of the \n\t\tsubmitted job will be written on stdout.\n\t-stop-manager <job ID>\n\t\tCause globusrun to stop the job manager, without killing \n\t\tthe job. If the save_state RSL attribute is present, then a\n\t\tjob manager can be restarted by using the restart RSL \n\t\tattribute.\n\t-fulldelegation\n\t\tPerform full delegation when submitting jobs.\n\n\tDiagnostic Options\n\t-p | -parse\n\t\tParse and validate the RSL only. Does not submit the job \n\t\tto a GRAM gatekeeper. Multi-requests are not supported.\n\t-a | -authenticate-only\n\t\tSubmit a gatekeeper \"ping\" request only. Do not parse the\n\t\tRSL or submit the job request. Requires the \n\t\t-resource-manger argument.\n\t-d | -dryrun\n\t\tSubmit the RSL to the job manager as a \"dryrun\" test\n\t\tThe request will be parsed and authenticated. The job \n\t\tmanager will execute all of the preliminary operations, \n\t\tand stop just before the job request would be executed.\n\n\tNot Supported Options\n\t-n | -no-interrupt\n";
    public static final int GLOBUSRUN_ARG_QUIET = 2;
    public static final int GLOBUSRUN_ARG_DRYRUN = 4;
    public static final int GLOBUSRUN_ARG_PARSE_ONLY = 8;
    public static final int GLOBUSRUN_ARG_AUTHENTICATE_ONLY = 16;
    public static final int GLOBUSRUN_ARG_USE_GASS = 32;
    public static final int GLOBUSRUN_ARG_ALLOW_READS = 64;
    public static final int GLOBUSRUN_ARG_ALLOW_WRITES = 128;
    public static final int GLOBUSRUN_ARG_BATCH = 512;
    public static final int GLOBUSRUN_ARG_ALLOW_OUTPUT = 4096;
    public static final int GLOBUSRUN_ARG_FULL_DELEGATION = 8192;
    private static boolean quiet = false;
    static /* synthetic */ Class class$org$globus$tools$GlobusRun;

    private static void status(String handle) {
        GramJob jb = new GramJob("");
        try {
            jb.setID(handle);
            Gram.jobStatus(jb);
            System.out.println(jb.getStatusAsString());
        }
        catch (MalformedURLException e) {
            System.err.println("Error: Invalid job handle: " + e.getMessage());
            GlobusRun.exit(1);
        }
        catch (GSSException e) {
            System.err.println("Security error: " + e.getMessage());
            GlobusRun.exit(1);
        }
        catch (GramException e) {
            if (e.getErrorCode() == 79) {
                System.out.println("DONE");
                GlobusRun.exit(0);
            }
            System.err.println("Failed to get job status: " + e.getMessage());
            GlobusRun.exit(1);
        }
        GlobusRun.exit(0);
    }

    private static void stopManager(String handle) {
        GramJob jb = new GramJob("");
        try {
            jb.setID(handle);
            jb.signal(9);
        }
        catch (MalformedURLException e) {
            System.err.println("Error: Invalid job handle: " + e.getMessage());
            GlobusRun.exit(1);
        }
        catch (GSSException e) {
            System.err.println("Security error: " + e.getMessage());
            GlobusRun.exit(1);
        }
        catch (GramException e) {
            System.err.println("Error stopping job manager: " + e.getMessage());
            GlobusRun.exit(1);
        }
        GlobusRun.exit(0);
    }

    private static void kill(String handle) {
        GramJob jb = new GramJob("");
        try {
            jb.setID(handle);
            Gram.cancel(jb);
        }
        catch (MalformedURLException e) {
            System.err.println("Invalid job handle");
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("GRAM Job cancel failed: " + e.getMessage());
            System.exit(1);
        }
        System.out.println("GRAM Job cancel successful");
        System.exit(0);
    }

    private static int ping(String rmc) {
        try {
            Gram.ping(rmc);
        }
        catch (Exception e) {
            System.out.println("GRAM Authentication test failed: " + e.getMessage());
            return 1;
        }
        System.out.println("GRAM Authentication test successful");
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readRSL(String file) {
        String string;
        BufferedReader reader = null;
        String line = null;
        StringBuffer rsl = null;
        try {
            try {
                reader = new BufferedReader(new FileReader(file));
                rsl = new StringBuffer();
                while ((line = reader.readLine()) != null) {
                    rsl.append(line.trim());
                }
                string = rsl.toString();
                Object var7_6 = null;
                if (reader == null) return string;
            }
            catch (IOException e) {
                System.err.println("Failed to read rsl file : " + e.getMessage());
                System.exit(1);
                String string2 = null;
                Object var7_7 = null;
                if (reader == null) return string2;
                try {
                    reader.close();
                    return string2;
                }
                catch (IOException ee) {
                    // empty catch block
                }
                return string2;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (reader == null) throw throwable;
            try {}
            catch (IOException ee) {
                throw throwable;
            }
            reader.close();
            throw throwable;
        }
        try {}
        catch (IOException ee) {
            // empty catch block
            return string;
        }
        reader.close();
        return string;
    }

    private static void exit(int err) {
        logger.debug("Exiting...");
        Deactivator.deactivateAll();
        System.exit(err);
    }

    private static void displaySyntax() {
        System.err.println();
        System.err.println("Syntax : java GlobusRun [-help] [-f RSL file] [-s][-b][-d][...] [-r RM] [RSL]");
        System.err.println();
        System.err.println("Use -help to display full usage.");
        System.exit(1);
    }

    public static void main(String[] args) {
        String rsl = null;
        String rmc = null;
        boolean ping = false;
        boolean error = false;
        int options = 0;
        if (args.length == 0) {
            System.err.println(message);
            System.exit(0);
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) != '-' && i + 1 == args.length) {
                if (rsl != null) {
                    error = true;
                    System.err.println("Error: RSL already specifed");
                    break;
                }
                rsl = args[i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-status")) {
                if (++i == args.length) {
                    error = true;
                    System.err.println("Error: -status requires a job handle");
                    break;
                }
                GlobusRun.status(args[i]);
                continue;
            }
            if (args[i].equals("-k") || args[i].equalsIgnoreCase("-kill")) {
                if (++i == args.length) {
                    error = true;
                    System.err.println("Error: -kill requires a job handle");
                    break;
                }
                GlobusRun.kill(args[i]);
                continue;
            }
            if (args[i].equals("-r") || args[i].equalsIgnoreCase("-resource-manager")) {
                if (++i == args.length) {
                    error = true;
                    System.err.println("Error: -r requires resource manager contact");
                    break;
                }
                rmc = args[i];
                continue;
            }
            if (args[i].equals("-b") || args[i].equalsIgnoreCase("-batch")) {
                options |= 0x200;
                continue;
            }
            if (args[i].equals("-d") || args[i].equalsIgnoreCase("-dryrun")) {
                options |= 4;
                continue;
            }
            if (args[i].equalsIgnoreCase("-fulldelegation")) {
                options |= 0x2000;
                continue;
            }
            if (args[i].equalsIgnoreCase("-stop-manager")) {
                if (++i == args.length) {
                    error = true;
                    System.err.println("Error: -stop-manager requires job ID");
                    break;
                }
                GlobusRun.stopManager(args[i]);
                continue;
            }
            if (args[i].equals("-a") || args[i].equalsIgnoreCase("-authenticate-only")) {
                options |= 0x10;
                continue;
            }
            if (args[i].equals("-o") || args[i].equalsIgnoreCase("-output-enable")) {
                options |= 0x1022;
                continue;
            }
            if (args[i].equals("-w") || args[i].equalsIgnoreCase("-write-allow")) {
                options |= 0xE2;
                continue;
            }
            if (args[i].equals("-f") || args[i].equalsIgnoreCase("-file")) {
                if (++i == args.length) {
                    error = true;
                    System.err.println("Error: -file requires a filename");
                    break;
                }
                rsl = GlobusRun.readRSL(args[i]);
                continue;
            }
            if (args[i].equals("-s") || args[i].equalsIgnoreCase("-server")) {
                options |= 0x62;
                continue;
            }
            if (args[i].equals("-q") || args[i].equalsIgnoreCase("-quiet")) {
                options |= 2;
                continue;
            }
            if (args[i].equals("-p") || args[i].equalsIgnoreCase("-parse")) {
                options |= 8;
                continue;
            }
            if (args[i].equals("-v") || args[i].equalsIgnoreCase("-version")) {
                System.err.println(Version.getVersion());
                System.exit(1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-help") || args[i].equalsIgnoreCase("-usage")) {
                System.err.println(message);
                System.exit(1);
                continue;
            }
            System.out.println("Error: argument #" + i + " (" + args[i] + ") : unknown");
            error = true;
        }
        if ((options & 0x200) != 0 && (options & 0x20) != 0) {
            error = true;
            System.err.println("Error: option -s and -b are exclusive");
        }
        if (error) {
            GlobusRun.displaySyntax();
        }
        if ((options & 0x10) != 0) {
            if (rmc == null) {
                System.err.println("Error: No resource manager contact specified for authentication test.");
                GlobusRun.displaySyntax();
            }
            System.exit(GlobusRun.ping(rmc));
        }
        if (rsl == null) {
            System.err.println("Error: Must specify a RSL string.");
            GlobusRun.displaySyntax();
        }
        RslNode rslTree = null;
        try {
            rslTree = RSLParser.parse(rsl);
        }
        catch (Throwable e) {
            System.err.println("Error: Cannot parse RSL: " + e.getMessage());
            System.exit(-1);
        }
        if ((options & 8) != 0) {
            System.out.println("RSL Parsed Successfully...\n");
            System.exit(0);
        }
        if (rslTree.getOperator() != 3 && rmc == null) {
            System.err.println("Error: No resource manager contact");
            GlobusRun.displaySyntax();
        }
        if ((options & 0x20) != 0) {
            String gassUrl = null;
            int server_options = 96;
            if ((options & 0x40) != 0) {
                server_options |= 8;
            }
            if ((options & 0x80) != 0) {
                server_options |= 0x10;
            }
            try {
                GassServer gassServer = new GassServer();
                gassServer.setOptions(server_options);
                gassServer.setTimeout(0);
                gassUrl = gassServer.getURL();
                gassServer.registerDefaultDeactivator();
                logger.debug(gassServer);
            }
            catch (IOException e) {
                System.err.println("Gass server initialization failed: " + e.getMessage());
                GlobusRun.exit(1);
            }
            GlobusRun.rslOutputSubst(rslTree, gassUrl, (options & 0x1000) != 0);
        }
        if ((options & 4) != 0) {
            GlobusRun.rslDryrunSubst(rslTree);
        }
        quiet = (options & 2) != 0;
        String finalRsl = rslTree.toRSL(true);
        logger.debug("RSL: " + finalRsl);
        if (rslTree.getOperator() == 3) {
            GlobusRun.multiRun(rslTree, options);
        } else {
            GlobusRun.gramRun(finalRsl, rmc, options);
        }
    }

    private static void println(String str) {
        if (!quiet) {
            System.out.println(str);
        }
    }

    private static void gramRun(String rsl, String rmc, int options) {
        JobListener jobListener = null;
        GramJob job = new GramJob(rsl);
        GlobusRun.println("Job status callback handler enabled.");
        jobListener = (options & 0x200) != 0 ? new BatchJobListener() : new InteractiveJobListener(quiet);
        job.addListener(jobListener);
        Exception exception = null;
        boolean sendCommit = false;
        try {
            job.request(rmc, false, (options & 0x2000) == 0);
        }
        catch (WaitingForCommitException e) {
            try {
                job.signal(5);
                sendCommit = true;
            }
            catch (Exception ee) {
                exception = ee;
            }
        }
        catch (Exception e) {
            exception = e;
        }
        if (exception instanceof GramException) {
            int err = ((GramException)exception).getErrorCode();
            GlobusRun.displayError((GramException)exception, options);
            GlobusRun.exit(err);
        } else if (exception instanceof GSSException) {
            System.err.println("Security error: " + exception.getMessage());
            GlobusRun.exit(1);
        } else if (exception != null) {
            logger.error("GRAM Job submission failed", exception);
            System.err.println("GRAM Job submisson failed: " + exception.getMessage());
            GlobusRun.exit(1);
        }
        GlobusRun.println("GRAM Job submission successful");
        if ((options & 0x200) != 0) {
            System.out.println(job.getIDAsString());
        }
        if (jobListener instanceof BatchJobListener) {
            logger.debug("Waiting for the job to start up...");
        } else {
            logger.debug("Waiting for the job to complete...");
        }
        try {
            jobListener.waitFor();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        job.removeListener(jobListener);
        int err = jobListener.getError();
        if (jobListener.isFinished()) {
            if (sendCommit) {
                logger.debug("Sending COMMIT_END signal");
                try {
                    job.signal(10);
                }
                catch (GramException e) {
                    logger.debug("Signal failed", e);
                    System.err.println("Signal failed: " + e.getMessage());
                    GlobusRun.exit(e.getErrorCode());
                }
                catch (GSSException e) {
                    logger.debug("Signal failed", e);
                    System.err.println("Security error: " + e.getMessage());
                    GlobusRun.exit(1);
                }
            }
        } else if ((options & 0x200) != 0) {
            try {
                job.unbind();
            }
            catch (GramException e) {
                logger.debug("Unbind failed", e);
                System.err.println("Unbind failed: " + e.getMessage());
                GlobusRun.exit(e.getErrorCode());
            }
            catch (GSSException e) {
                logger.debug("Unbind failed", e);
                System.err.println("Security error: " + e.getMessage());
                GlobusRun.exit(1);
            }
        }
        GlobusRun.displayError(err, options);
        GlobusRun.exit(err);
    }

    private static void displayError(int errorCode, int options) {
        if (errorCode == 41 && (options & 4) != 0) {
            GlobusRun.println("Dryrun successful");
        } else if (errorCode != 0) {
            System.err.println("GRAM Job submission failed: " + GramException.getMessage(errorCode) + " (error code " + errorCode + ")");
        }
    }

    private static void displayError(GramException exception, int options) {
        int errorCode = exception.getErrorCode();
        if (errorCode == 41 && (options & 4) != 0) {
            GlobusRun.println("Dryrun successful");
        } else if (errorCode != 0) {
            logger.error("GRAM Job submission failed", exception);
            System.err.println("GRAM Job submission failed: " + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void multiRun(RslNode rslTree, int options) {
        if ((options & 0x200) != 0) {
            System.err.println("Error: Batch mode (-b) not supported for multi-request");
            GlobusRun.exit(1);
        }
        MultiJobListener listener = new MultiJobListener(quiet);
        List jobs = rslTree.getSpecifications();
        Iterator iter = jobs.iterator();
        while (iter.hasNext()) {
            RslNode node = (RslNode)iter.next();
            String rsl = node.toRSL(true);
            NameOpValue nv = node.getParam("resourceManagerContact");
            if (nv == null) {
                System.err.println("Error: No resource manager contact for job.");
                continue;
            }
            Object obj = nv.getFirstValue();
            if (!(obj instanceof Value)) continue;
            String rmc = ((Value)obj).getValue();
            GlobusRun.multiRunSub(rsl, rmc, options, listener);
        }
        logger.debug("Waiting for jobs to complete...");
        MultiJobListener multiJobListener = listener;
        synchronized (multiJobListener) {
            try {
                listener.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        logger.debug("Exiting...");
        Deactivator.deactivateAll();
    }

    private static void multiRunSub(String rsl, String rmc, int options, MultiJobListener listener) {
        GramJob job = new GramJob(rsl);
        job.addListener(listener);
        Exception exception = null;
        try {
            job.request(rmc, false, (options & 0x2000) == 0);
        }
        catch (WaitingForCommitException e) {
            try {
                job.signal(5);
            }
            catch (Exception ee) {
                exception = ee;
            }
        }
        catch (Exception e) {
            exception = e;
        }
        if (exception instanceof GramException) {
            if (((GramException)exception).getErrorCode() == 41 && (options & 4) != 0) {
                GlobusRun.println("Dryrun successful");
            } else {
                System.err.println("GRAM Job submission failed: " + exception.getMessage() + " (error code " + ((GramException)exception).getErrorCode() + ", rsl: " + rsl + ")");
            }
            return;
        }
        if (exception instanceof GSSException) {
            System.err.println("Security error: " + exception.getMessage());
            GlobusRun.exit(1);
        } else if (exception != null) {
            System.err.println("GRAM Job submisson failed: " + exception.getMessage());
            return;
        }
        listener.runningJob();
        GlobusRun.println("GRAM Job submission successful (rmc: " + rmc + ")");
    }

    private static void rslDryrunSubst(RslNode rslTree) {
        if (rslTree.getOperator() == 3) {
            List specs = rslTree.getSpecifications();
            Iterator iter = specs.iterator();
            while (iter.hasNext()) {
                RslNode node = (RslNode)iter.next();
                GlobusRun.rslDryrunSubst(node);
            }
        } else {
            rslTree.put(new NameOpValue("dryrun", 1, "yes"));
        }
    }

    private static void rslOutputSubst(RslNode rslTree, String gassUrl, boolean allowOutput) {
        if (rslTree.getOperator() == 3) {
            List specs = rslTree.getSpecifications();
            Iterator iter = specs.iterator();
            while (iter.hasNext()) {
                RslNode node = (RslNode)iter.next();
                GlobusRun.rslOutputSubst(node, gassUrl, allowOutput);
            }
        } else {
            Binding bd = new Binding("GLOBUSRUN_GASS_URL", gassUrl);
            Bindings bind = rslTree.getBindings("rsl_substitution");
            if (bind == null) {
                bind = new Bindings("rsl_substitution");
                rslTree.put(bind);
            }
            bind.add(bd);
            if (allowOutput) {
                VarRef value = null;
                value = new VarRef("GLOBUSRUN_GASS_URL", null, new Value("/dev/stdout"));
                rslTree.put(new NameOpValue("stdout", 1, value));
                value = new VarRef("GLOBUSRUN_GASS_URL", null, new Value("/dev/stderr"));
                rslTree.put(new NameOpValue("stderr", 1, value));
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

