/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authentication;

import javax.xml.namespace.QName;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.impl.security.authentication.UsernameSOAPEnvelopeBuilder;
import org.globus.wsrf.impl.security.authentication.wssec.WSSecurityFault;

public class UsernameHandler
extends GenericHandler {
    protected static I18n i18n = I18n.getI18n("org.globus.wsrf.impl.security.authentication.errors");
    private static Log log = LogFactory.getLog(UsernameHandler.class.getName());

    public boolean handleRequest(MessageContext context) {
        return this.handleMessage((SOAPMessageContext)context);
    }

    public boolean handleResponse(MessageContext context) {
        return this.handleMessage((SOAPMessageContext)context);
    }

    public boolean handleMessage(SOAPMessageContext ctx) {
        Object tmp = ctx.getProperty("org.globus.security.username");
        if (tmp == null) {
            log.debug("User name is not set");
            return true;
        }
        SOAPMessage msg = ctx.getMessage();
        if (msg == null) {
            log.debug("No message");
            return true;
        }
        log.debug("user name is " + tmp);
        UsernameSOAPEnvelopeBuilder builder = new UsernameSOAPEnvelopeBuilder(ctx, (String)tmp);
        builder.setActor((String)ctx.getProperty("x509Actor"));
        SOAPMessage soapMsg = null;
        try {
            SOAPEnvelope envelope = msg.getSOAPPart().getEnvelope();
            soapMsg = builder.buildMessage(envelope);
        }
        catch (Exception exp) {
            log.error(i18n.getMessage("userPassAdd"), exp);
            throw WSSecurityFault.makeFault(exp);
        }
        ctx.setMessage(soapMsg);
        log.debug("Exit username handler");
        return true;
    }

    public QName[] getHeaders() {
        return null;
    }
}

