/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.dav.items;

import com.ecyrd.jspwiki.dav.DavPath;
import com.ecyrd.jspwiki.dav.DavProvider;
import com.ecyrd.jspwiki.dav.items.DavItem;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang.time.DateFormatUtils;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

public class DirectoryItem
extends DavItem {
    public DirectoryItem(DavProvider provider, DavPath path) {
        super(provider, path);
    }

    public String getContentType() {
        return "text/plain; charset=UTF-8";
    }

    public long getLength() {
        return -1L;
    }

    public Collection getPropertySet() {
        ArrayList<Element> ts = new ArrayList<Element>();
        Namespace davns = Namespace.getNamespace((String)"DAV:");
        ts.add(new Element("resourcetype", davns).addContent((Content)new Element("collection", davns)));
        Element txt = new Element("displayname", davns);
        txt.setText(this.m_path.getName());
        ts.add(txt);
        ts.add(new Element("getcontentlength", davns).setText("0"));
        ts.add(new Element("getlastmodified", davns).setText(DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(new Date())));
        return ts;
    }

    public String getHref() {
        return this.m_provider.getURL(this.m_path);
    }

    public void addDavItem(DavItem di) {
        this.m_items.add(di);
    }

    public void addDavItems(Collection c) {
        this.m_items.addAll(c);
    }

    public InputStream getInputStream() {
        return null;
    }
}

