/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.docidset;

import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;

public class BitsetDocSet
extends DocIdSet {
    private final BitSet _bs;

    public BitsetDocSet() {
        this._bs = new BitSet();
    }

    public BitsetDocSet(int nbits) {
        this._bs = new BitSet(nbits);
    }

    public void addDoc(int docid) {
        this._bs.set(docid);
    }

    public int size() {
        return this._bs.cardinality();
    }

    public DocIdSetIterator iterator() {
        return new BitsDocIdSetIterator(this._bs);
    }

    private static class BitsDocIdSetIterator
    extends DocIdSetIterator {
        private final BitSet _bs;
        private int _current;

        BitsDocIdSetIterator(BitSet bs) {
            this._bs = bs;
            this._current = -1;
        }

        public int docID() {
            return this._current;
        }

        public int nextDoc() throws IOException {
            return this._bs.nextSetBit(this._current + 1);
        }

        public int advance(int target) throws IOException {
            return this._bs.nextSetBit(target);
        }
    }
}

