/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.error.Error;
import org.hsqldb.lib.LineReader;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.result.Result;
import org.hsqldb.rowio.RowInputTextLog;
import org.hsqldb.scriptio.ScriptReaderBase;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Type;

public class ScriptReaderText
extends ScriptReaderBase {
    LineReader dataStreamIn;
    RowInputTextLog rowIn;
    boolean isInsert;

    public ScriptReaderText(Database db) {
        super(db);
    }

    public ScriptReaderText(Database db, String fileName, boolean compressed) throws IOException {
        super(db);
        InputStream inputStream = this.database.logger.getFileAccess().openInputStreamElement(fileName);
        inputStream = new BufferedInputStream(inputStream);
        if (compressed) {
            inputStream = new GZIPInputStream(inputStream);
        }
        this.dataStreamIn = new LineReader(inputStream, "ISO-8859-1");
        this.rowIn = new RowInputTextLog(db.databaseProperties.isVersion18());
    }

    public ScriptReaderText(Database db, InputStream inputStream) {
        super(db);
        this.dataStreamIn = new LineReader(inputStream, "ISO-8859-1");
        this.rowIn = new RowInputTextLog(db.databaseProperties.isVersion18());
    }

    protected void readDDL(Session session) throws IOException {
        while (this.readLoggedStatement(session)) {
            Statement cs = null;
            Result result = null;
            if (this.rowIn.getStatementType() == 3) {
                this.isInsert = true;
                break;
            }
            try {
                cs = session.compileStatement(this.statement);
                result = session.executeCompiledStatement(cs, ValuePool.emptyObjectArray);
            }
            catch (HsqlException e) {
                result = Result.newErrorResult(e);
            }
            if (result.isError() && cs != null && (cs.getType() == 48 || cs.getType() == 14 && result.getMainString().contains("org.hsqldb.Library")) || !result.isError()) continue;
            this.database.logger.logWarningEvent(result.getMainString(), result.getException());
            if (cs != null && cs.getType() == 14) continue;
            throw Error.error(result.getException(), 461, 25, new Object[]{new Integer(this.lineCount), result.getMainString()});
        }
    }

    protected void readExistingData(Session session) throws IOException {
        try {
            String tablename = null;
            this.database.setReferentialIntegrity(false);
            while (this.isInsert || this.readLoggedStatement(session)) {
                if (this.statementType == 6) {
                    session.setSchema(this.currentSchema);
                } else if (this.statementType == 3) {
                    if (!this.rowIn.getTableName().equals(tablename)) {
                        tablename = this.rowIn.getTableName();
                        String schema = session.getSchemaName(this.currentSchema);
                        this.currentTable = this.database.schemaManager.getUserTable(session, tablename, schema);
                        this.currentStore = this.database.persistentStoreCollection.getStore(this.currentTable);
                    }
                    this.currentTable.insertFromScript(session, this.currentStore, this.rowData);
                } else {
                    throw Error.error(461);
                }
                this.isInsert = false;
            }
            this.database.setReferentialIntegrity(true);
        }
        catch (Throwable t) {
            this.database.logger.logSevereEvent("readExistingData failed", t);
            throw Error.error(t, 461, 25, new Object[]{new Integer(this.lineCount), t.toString()});
        }
    }

    public boolean readLoggedStatement(Session session) throws IOException {
        if (!this.sessionChanged) {
            String s = this.dataStreamIn.readLine();
            ++this.lineCount;
            this.statement = StringConverter.unicodeStringToString(s);
            if (this.statement == null) {
                return false;
            }
        }
        this.processStatement(session);
        return true;
    }

    void processStatement(Session session) throws IOException {
        try {
            if (this.statement.startsWith("/*C")) {
                int endid = this.statement.indexOf(42, 4);
                this.sessionNumber = Integer.parseInt(this.statement.substring(3, endid));
                this.statement = this.statement.substring(endid + 2);
                this.sessionChanged = true;
                this.statementType = 5;
                return;
            }
            this.sessionChanged = false;
            this.rowIn.setSource(this.statement);
            this.statementType = this.rowIn.getStatementType();
            if (this.statementType == 1) {
                this.rowData = null;
                this.currentTable = null;
                return;
            }
            if (this.statementType == 4) {
                this.rowData = null;
                this.currentTable = null;
                return;
            }
            if (this.statementType == 6) {
                this.rowData = null;
                this.currentTable = null;
                this.currentSchema = this.rowIn.getSchemaName();
                return;
            }
            String name = this.rowIn.getTableName();
            String schema = session.getCurrentSchemaHsqlName().name;
            this.currentTable = this.database.schemaManager.getUserTable(session, name, schema);
            this.currentStore = this.database.persistentStoreCollection.getStore(this.currentTable);
            Type[] colTypes = this.statementType == 3 ? this.currentTable.getColumnTypes() : (this.currentTable.hasPrimaryKey() ? this.currentTable.getPrimaryKeyTypes() : this.currentTable.getColumnTypes());
            this.rowData = this.rowIn.readData(colTypes);
        }
        catch (Exception e) {
            System.out.println(this.statement);
            throw JavaSystem.toIOException(e);
        }
    }

    public void close() {
        try {
            this.dataStreamIn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

