/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.nio.intraband;

import com.liferay.portal.kernel.io.BigEndianCodec;
import com.liferay.portal.kernel.nio.intraband.CompletionHandler;
import com.liferay.portal.kernel.util.StringBundler;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.util.EnumSet;

public class Datagram {
    protected Object attachment;
    protected CompletionHandler<Object> completionHandler;
    protected EnumSet<CompletionHandler.CompletionType> completionTypes;
    protected long expireTime;
    protected long timeout;
    private static final ByteBuffer _EMPTY_BUFFER = ByteBuffer.allocate(0);
    private static final byte _FLAG_ACK_REQUEST = 1;
    private static final byte _FLAG_ACK_RESPONSE = 2;
    private static final byte _FLAG_REQUEST = 4;
    private static final byte _FLAG_RESPONSE = 8;
    private static final int _HEADER_SIZE = 14;
    private static final int _INDEX_DATA_SIZE = 10;
    private static final int _INDEX_DATA_TYPE = 9;
    private static final int _INDEX_SEQUENCE_ID = 1;
    private static final int _INDEX_STATUS_FLAG = 0;
    private ByteBuffer _dataByteBuffer;
    private final byte[] _headerBufferArray;
    private final ByteBuffer _headerByteBuffer = ByteBuffer.allocate(14);

    public static Datagram createRequestDatagram(byte type, byte[] data) {
        return Datagram.createRequestDatagram(type, ByteBuffer.wrap(data));
    }

    public static Datagram createRequestDatagram(byte type, ByteBuffer dataByteBuffer) {
        Datagram datagram = new Datagram();
        datagram._headerBufferArray[0] = 4;
        datagram._headerBufferArray[9] = type;
        BigEndianCodec.putInt(datagram._headerBufferArray, 10, dataByteBuffer.remaining());
        datagram._dataByteBuffer = dataByteBuffer;
        return datagram;
    }

    public static Datagram createResponseDatagram(Datagram requestDatagram, byte[] data) {
        return Datagram.createResponseDatagram(requestDatagram, ByteBuffer.wrap(data));
    }

    public static Datagram createResponseDatagram(Datagram requestDatagram, ByteBuffer byteBuffer) {
        Datagram datagram = new Datagram();
        datagram._headerBufferArray[0] = 8;
        BigEndianCodec.putLong(datagram._headerBufferArray, 1, requestDatagram.getSequenceId());
        BigEndianCodec.putInt(datagram._headerBufferArray, 10, byteBuffer.remaining());
        datagram._dataByteBuffer = byteBuffer;
        return datagram;
    }

    public ByteBuffer getDataByteBuffer() {
        return this._dataByteBuffer;
    }

    public byte getType() {
        return this._headerBufferArray[9];
    }

    public String toString() {
        StringBundler sb = new StringBundler(11);
        sb.append("{dataChunk=");
        ByteBuffer byteBuffer = this._dataByteBuffer;
        if (byteBuffer == null) {
            sb.append("null");
        } else {
            sb.append(byteBuffer.toString());
        }
        sb.append(", dataSize=");
        sb.append(BigEndianCodec.getInt(this._headerBufferArray, 10));
        sb.append(", dataType=");
        sb.append(this._headerBufferArray[9]);
        sb.append(", sequenceId=");
        sb.append(BigEndianCodec.getLong(this._headerBufferArray, 1));
        sb.append(", statusFlag=");
        sb.append(this._headerBufferArray[0]);
        sb.append("}");
        return sb.toString();
    }

    protected static Datagram createACKResponseDatagram(long sequenceId) {
        Datagram datagram = new Datagram();
        datagram._headerBufferArray[0] = 2;
        BigEndianCodec.putLong(datagram._headerBufferArray, 1, sequenceId);
        BigEndianCodec.putInt(datagram._headerBufferArray, 10, 0);
        datagram._dataByteBuffer = _EMPTY_BUFFER;
        return datagram;
    }

    protected static Datagram createReceiveDatagram() {
        return new Datagram();
    }

    protected long getSequenceId() {
        return BigEndianCodec.getLong(this._headerBufferArray, 1);
    }

    protected boolean isAckRequest() {
        byte statusFlag = this._headerBufferArray[0];
        return (statusFlag & 1) != 0;
    }

    protected boolean isAckResponse() {
        byte statusFlag = this._headerBufferArray[0];
        return (statusFlag & 2) != 0;
    }

    protected boolean isRequest() {
        byte statusFlag = this._headerBufferArray[0];
        return (statusFlag & 4) != 0;
    }

    protected boolean isResponse() {
        byte statusFlag = this._headerBufferArray[0];
        return (statusFlag & 8) != 0;
    }

    protected boolean readFrom(ScatteringByteChannel scatteringByteChannel) throws IOException {
        if (this._headerByteBuffer.hasRemaining()) {
            if (scatteringByteChannel.read(this._headerByteBuffer) == -1) {
                throw new EOFException();
            }
            if (this._headerByteBuffer.hasRemaining()) {
                return false;
            }
            int dataSize = BigEndianCodec.getInt(this._headerBufferArray, 10);
            if (dataSize == 0) {
                this._dataByteBuffer = _EMPTY_BUFFER;
                return true;
            }
            this._dataByteBuffer = ByteBuffer.allocate(dataSize);
        }
        if (scatteringByteChannel.read(this._dataByteBuffer) == -1) {
            throw new EOFException();
        }
        if (this._dataByteBuffer.hasRemaining()) {
            return false;
        }
        this._dataByteBuffer.flip();
        return true;
    }

    protected void setAckRequest(boolean ackRequest) {
        byte statusFlag = this._headerBufferArray[0];
        statusFlag = ackRequest ? (byte)(statusFlag | 1) : (byte)(statusFlag & 0xFFFFFFFE);
        this._headerBufferArray[0] = statusFlag;
    }

    protected void setSequenceId(long sequenceId) {
        BigEndianCodec.putLong(this._headerBufferArray, 1, sequenceId);
    }

    protected boolean writeTo(GatheringByteChannel gatheringByteChannel) throws IOException {
        if (this._headerByteBuffer.hasRemaining()) {
            ByteBuffer[] byteBuffers = new ByteBuffer[]{this._headerByteBuffer, this._dataByteBuffer};
            gatheringByteChannel.write(byteBuffers);
        } else {
            gatheringByteChannel.write(this._dataByteBuffer);
        }
        if (this._dataByteBuffer.hasRemaining()) {
            return false;
        }
        this._dataByteBuffer = null;
        return true;
    }

    private Datagram() {
        this._headerBufferArray = this._headerByteBuffer.array();
    }
}

