/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.webservices;

import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.Holder;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractPortProvider;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractWebServicesService;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.Converter;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisException;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.PolicyServicePort;
import org.apache.chemistry.opencmis.commons.spi.PolicyService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyServiceImpl
extends AbstractWebServicesService
implements PolicyService {
    private final AbstractPortProvider portProvider;

    public PolicyServiceImpl(BindingSession session, AbstractPortProvider portProvider) {
        this.setSession(session);
        this.portProvider = portProvider;
    }

    public void applyPolicy(String repositoryId, String policyId, String objectId, ExtensionsData extension) {
        PolicyServicePort port = this.portProvider.getPolicyServicePort();
        try {
            Holder portExtension = Converter.convertExtensionHolder((ExtensionsData)extension);
            port.applyPolicy(repositoryId, policyId, objectId, portExtension);
            Converter.setExtensionValues((Holder)portExtension, (ExtensionsData)extension);
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public void removePolicy(String repositoryId, String policyId, String objectId, ExtensionsData extension) {
        PolicyServicePort port = this.portProvider.getPolicyServicePort();
        try {
            Holder portExtension = Converter.convertExtensionHolder((ExtensionsData)extension);
            port.removePolicy(repositoryId, policyId, objectId, portExtension);
            Converter.setExtensionValues((Holder)portExtension, (ExtensionsData)extension);
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public List<ObjectData> getAppliedPolicies(String repositoryId, String objectId, String filter, ExtensionsData extension) {
        PolicyServicePort port = this.portProvider.getPolicyServicePort();
        try {
            List policyList = port.getAppliedPolicies(repositoryId, objectId, filter, Converter.convert((ExtensionsData)extension));
            ArrayList<ObjectData> result = new ArrayList<ObjectData>();
            if (policyList == null) {
                ArrayList<ObjectData> arrayList = result;
                return arrayList;
            }
            for (CmisObjectType policy : policyList) {
                result.add(Converter.convert((CmisObjectType)policy));
            }
            ArrayList<ObjectData> arrayList = result;
            return arrayList;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }
}

