/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.xsl;

import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.template.StringTemplateResource;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.template.TemplateContextHelper;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.xsl.XSLErrorListener;
import com.liferay.portal.xsl.XSLTemplateResource;
import com.liferay.portal.xsl.XSLURIResolver;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XSLTemplate
implements Template {
    private Map<String, Object> _context;
    private TemplateResource _errorTemplateResource;
    private TemplateContextHelper _templateContextHelper;
    private XSLTemplateResource _xslTemplateResource;

    public XSLTemplate(XSLTemplateResource xslTemplateResource, TemplateResource errorTemplateResource, TemplateContextHelper templateContextHelper) {
        if (xslTemplateResource == null) {
            throw new IllegalArgumentException("XSL template resource is null");
        }
        if (templateContextHelper == null) {
            throw new IllegalArgumentException("Template context helper is null");
        }
        this._xslTemplateResource = xslTemplateResource;
        this._errorTemplateResource = errorTemplateResource;
        this._templateContextHelper = templateContextHelper;
        this._context = new HashMap<String, Object>();
    }

    public Object get(String key) {
        return this._context.get(key);
    }

    public String[] getKeys() {
        Set<String> keys = this._context.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    public void prepare(HttpServletRequest request) {
        this._templateContextHelper.prepare(this, request);
    }

    public void processTemplate(Writer writer) throws TemplateException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", PropsValues.XSL_TEMPLATE_SECURE_PROCESSING_ENABLED);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {}
        String languageId = null;
        XSLURIResolver xslURIResolver = this._xslTemplateResource.getXSLURIResolver();
        if (xslURIResolver != null) {
            languageId = xslURIResolver.getLanguageId();
        }
        Locale locale = LocaleUtil.fromLanguageId(languageId);
        XSLErrorListener xslErrorListener = new XSLErrorListener(locale);
        transformerFactory.setErrorListener(xslErrorListener);
        transformerFactory.setURIResolver(xslURIResolver);
        StreamSource xmlSource = new StreamSource(this._xslTemplateResource.getXMLReader());
        Transformer transformer = null;
        if (this._errorTemplateResource == null) {
            try {
                transformer = this._getTransformer(transformerFactory, this._xslTemplateResource);
                transformer.transform(xmlSource, new StreamResult(writer));
                return;
            }
            catch (Exception e2) {
                throw new TemplateException("Unable to process XSL template " + this._xslTemplateResource.getTemplateId(), (Throwable)e2);
            }
        }
        try {
            UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
            transformer = this._getTransformer(transformerFactory, this._xslTemplateResource);
            transformer.setParameter("writer", unsyncStringWriter);
            transformer.transform(xmlSource, new StreamResult((Writer)unsyncStringWriter));
            StringBundler sb = unsyncStringWriter.getStringBundler();
            sb.writeTo(writer);
        }
        catch (Exception exception) {
            Transformer errorTransformer = this._getTransformer(transformerFactory, this._errorTemplateResource);
            errorTransformer.setParameter("writer", writer);
            errorTransformer.setParameter("exception", xslErrorListener.getMessageAndLocation());
            if (this._errorTemplateResource instanceof StringTemplateResource) {
                StringTemplateResource stringTemplateResource = (StringTemplateResource)this._errorTemplateResource;
                errorTransformer.setParameter("script", stringTemplateResource.getContent());
            }
            if (xslErrorListener.getLocation() != null) {
                errorTransformer.setParameter("column", new Integer(xslErrorListener.getColumnNumber()));
                errorTransformer.setParameter("line", new Integer(xslErrorListener.getLineNumber()));
            }
            try {
                errorTransformer.transform(xmlSource, new StreamResult(writer));
            }
            catch (Exception e2) {
                throw new TemplateException("Unable to process XSL template " + this._errorTemplateResource.getTemplateId(), (Throwable)e2);
            }
        }
    }

    public void put(String key, Object value) {
        if (value == null) {
            return;
        }
        this._context.put(key, value);
    }

    private Transformer _getTransformer(TransformerFactory transformerFactory, TemplateResource templateResource) throws TemplateException {
        try {
            StreamSource scriptSource = new StreamSource(templateResource.getReader());
            Transformer transformer = AccessController.doPrivileged(new TransformerPrivilegedExceptionAction(transformerFactory, scriptSource));
            for (Map.Entry<String, Object> entry : this._context.entrySet()) {
                transformer.setParameter(entry.getKey(), entry.getValue());
            }
            return transformer;
        }
        catch (PrivilegedActionException pae) {
            throw new TemplateException("Unable to get Transformer for template " + templateResource.getTemplateId(), (Throwable)pae.getException());
        }
        catch (Exception e2) {
            throw new TemplateException("Unable to get Transformer for template " + templateResource.getTemplateId(), (Throwable)e2);
        }
    }

    private class TransformerPrivilegedExceptionAction
    implements PrivilegedExceptionAction<Transformer> {
        private StreamSource _scriptSource;
        private TransformerFactory _transformerFactory;

        public TransformerPrivilegedExceptionAction(TransformerFactory transformerFactory, StreamSource scriptSource) {
            this._transformerFactory = transformerFactory;
            this._scriptSource = scriptSource;
        }

        @Override
        public Transformer run() throws Exception {
            return this._transformerFactory.newTransformer(this._scriptSource);
        }
    }
}

