/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.trash;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.trash.BaseTrashHandler;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.model.ContainerModel;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.service.BookmarksEntryLocalServiceUtil;
import com.liferay.portlet.bookmarks.service.BookmarksFolderLocalServiceUtil;
import java.util.ArrayList;
import java.util.List;

public abstract class BookmarksBaseTrashHandler
extends BaseTrashHandler {
    public ContainerModel getContainerModel(long containerModelId) throws PortalException, SystemException {
        return BookmarksFolderLocalServiceUtil.getFolder((long)containerModelId);
    }

    public String getContainerModelClassName() {
        return BookmarksFolder.class.getName();
    }

    public String getContainerModelName() {
        return "folder";
    }

    public List<ContainerModel> getContainerModels(long classPK, long parentContainerModelId, int start, int end) throws PortalException, SystemException {
        List folders = BookmarksFolderLocalServiceUtil.getFolders((long)this.getGroupId(classPK), (long)parentContainerModelId, (int)start, (int)end);
        ArrayList<ContainerModel> containerModels = new ArrayList<ContainerModel>(folders.size());
        for (BookmarksFolder curFolder : folders) {
            containerModels.add((ContainerModel)curFolder);
        }
        return containerModels;
    }

    public int getContainerModelsCount(long classPK, long parentContainerModelId) throws PortalException, SystemException {
        return BookmarksFolderLocalServiceUtil.getFoldersCount((long)this.getGroupId(classPK), (long)parentContainerModelId);
    }

    public List<ContainerModel> getParentContainerModels(long classPK) throws PortalException, SystemException {
        ArrayList<ContainerModel> containerModels = new ArrayList<ContainerModel>();
        ContainerModel containerModel = this.getParentContainerModel(classPK);
        if (containerModel == null) {
            return containerModels;
        }
        containerModels.add(containerModel);
        while (containerModel.getParentContainerModelId() > 0L) {
            if ((containerModel = this.getContainerModel(containerModel.getParentContainerModelId())) == null) break;
            containerModels.add(containerModel);
        }
        return containerModels;
    }

    public String getRootContainerModelName() {
        return "home";
    }

    public String getTrashContainedModelName() {
        return "bookmarks";
    }

    public int getTrashContainedModelsCount(long classPK) throws PortalException, SystemException {
        BookmarksFolder folder = BookmarksFolderLocalServiceUtil.getFolder((long)classPK);
        return BookmarksEntryLocalServiceUtil.getEntriesCount((long)folder.getGroupId(), (long)classPK, (int)8);
    }

    public List<TrashRenderer> getTrashContainedModelTrashRenderers(long classPK, int start, int end) throws PortalException, SystemException {
        ArrayList<TrashRenderer> trashRenderers = new ArrayList<TrashRenderer>();
        BookmarksFolder folder = BookmarksFolderLocalServiceUtil.getFolder((long)classPK);
        List entries = BookmarksEntryLocalServiceUtil.getEntries((long)folder.getGroupId(), (long)classPK, (int)8, (int)start, (int)end);
        for (BookmarksEntry entry : entries) {
            TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)BookmarksEntry.class.getName());
            TrashRenderer trashRenderer = trashHandler.getTrashRenderer(entry.getEntryId());
            trashRenderers.add(trashRenderer);
        }
        return trashRenderers;
    }

    public String getTrashContainerModelName() {
        return "folders";
    }

    public int getTrashContainerModelsCount(long classPK) throws PortalException, SystemException {
        BookmarksFolder folder = BookmarksFolderLocalServiceUtil.getFolder((long)classPK);
        return BookmarksFolderLocalServiceUtil.getFoldersCount((long)folder.getGroupId(), (long)classPK, (int)8);
    }

    public List<TrashRenderer> getTrashContainerModelTrashRenderers(long classPK, int start, int end) throws PortalException, SystemException {
        ArrayList<TrashRenderer> trashRenderers = new ArrayList<TrashRenderer>();
        BookmarksFolder folder = BookmarksFolderLocalServiceUtil.getFolder((long)classPK);
        List folders = BookmarksFolderLocalServiceUtil.getFolders((long)folder.getGroupId(), (long)classPK, (int)8, (int)start, (int)end);
        for (BookmarksFolder curFolder : folders) {
            TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)BookmarksFolder.class.getName());
            TrashRenderer trashRenderer = trashHandler.getTrashRenderer(curFolder.getPrimaryKey());
            trashRenderers.add(trashRenderer);
        }
        return trashRenderers;
    }

    public boolean isMovable() {
        return true;
    }

    protected abstract long getGroupId(long var1) throws PortalException, SystemException;
}

