/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portlet.journal.DuplicateArticleImageIdException;
import com.liferay.portlet.journal.model.JournalArticleImage;
import com.liferay.portlet.journal.service.base.JournalArticleImageLocalServiceBaseImpl;
import java.util.List;

public class JournalArticleImageLocalServiceImpl
extends JournalArticleImageLocalServiceBaseImpl {
    public void addArticleImageId(long articleImageId, long groupId, String articleId, double version, String elInstanceId, String elName, String languageId) throws PortalException, SystemException {
        if (articleImageId <= 0L) {
            return;
        }
        JournalArticleImage articleImage = this.journalArticleImagePersistence.fetchByG_A_V_E_E_L(groupId, articleId, version, elInstanceId, elName, languageId);
        if (articleImage == null) {
            articleImage = this.journalArticleImagePersistence.create(articleImageId);
            articleImage.setGroupId(groupId);
            articleImage.setArticleId(articleId);
            articleImage.setVersion(version);
            articleImage.setElInstanceId(elInstanceId);
            articleImage.setElName(elName);
            articleImage.setLanguageId(languageId);
            articleImage.setTempImage(false);
            this.journalArticleImagePersistence.update((BaseModel)articleImage);
        } else if (articleImage.getArticleImageId() != articleImageId) {
            throw new DuplicateArticleImageIdException("{articleImageId=" + articleImageId + "}");
        }
    }

    public void deleteArticleImage(JournalArticleImage articleImage) throws SystemException {
        try {
            this.imageLocalService.deleteImage(articleImage.getArticleImageId());
        }
        catch (PortalException portalException) {}
        this.journalArticleImagePersistence.remove((BaseModel)articleImage);
    }

    public void deleteArticleImage(long articleImageId) throws SystemException {
        JournalArticleImage articleImage = this.journalArticleImagePersistence.fetchByPrimaryKey(articleImageId);
        if (articleImage != null) {
            this.deleteArticleImage(articleImage);
        }
    }

    public void deleteArticleImage(long groupId, String articleId, double version, String elInstanceId, String elName, String languageId) throws SystemException {
        JournalArticleImage articleImage = this.journalArticleImagePersistence.fetchByG_A_V_E_E_L(groupId, articleId, version, elInstanceId, elName, languageId);
        if (articleImage != null) {
            this.deleteArticleImage(articleImage);
        }
    }

    public void deleteImages(long groupId, String articleId, double version) throws SystemException {
        for (JournalArticleImage articleImage : this.journalArticleImagePersistence.findByG_A_V(groupId, articleId, version)) {
            this.deleteArticleImage(articleImage);
        }
    }

    public JournalArticleImage getArticleImage(long articleImageId) throws PortalException, SystemException {
        return this.journalArticleImagePersistence.findByPrimaryKey(articleImageId);
    }

    public long getArticleImageId(long groupId, String articleId, double version, String elInstanceId, String elName, String languageId) throws SystemException {
        return this.getArticleImageId(groupId, articleId, version, elInstanceId, elName, languageId, false);
    }

    public long getArticleImageId(long groupId, String articleId, double version, String elInstanceId, String elName, String languageId, boolean tempImage) throws SystemException {
        JournalArticleImage articleImage = this.journalArticleImagePersistence.fetchByG_A_V_E_E_L(groupId, articleId, version, elInstanceId, elName, languageId);
        if (articleImage == null) {
            long articleImageId = this.counterLocalService.increment();
            articleImage = this.journalArticleImagePersistence.create(articleImageId);
            articleImage.setGroupId(groupId);
            articleImage.setArticleId(articleId);
            articleImage.setVersion(version);
            articleImage.setElInstanceId(elInstanceId);
            articleImage.setElName(elName);
            articleImage.setLanguageId(languageId);
            articleImage.setTempImage(tempImage);
            this.journalArticleImagePersistence.update((BaseModel)articleImage);
        }
        return articleImage.getArticleImageId();
    }

    public List<JournalArticleImage> getArticleImages(long groupId) throws SystemException {
        return this.journalArticleImagePersistence.findByGroupId(groupId);
    }

    public List<JournalArticleImage> getArticleImages(long groupId, String articleId, double version) throws SystemException {
        return this.journalArticleImagePersistence.findByG_A_V(groupId, articleId, version);
    }
}

