/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging.config;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationEventListener;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.config.MessagingConfigurator;
import com.liferay.portal.kernel.messaging.config.MessagingConfiguratorRegistry;
import com.liferay.portal.kernel.nio.intraband.RegistrationReference;
import com.liferay.portal.kernel.nio.intraband.messaging.DestinationConfigurationProcessCallable;
import com.liferay.portal.kernel.nio.intraband.messaging.IntrabandBridgeDestination;
import com.liferay.portal.kernel.nio.intraband.rpc.IntrabandRPCUtil;
import com.liferay.portal.kernel.resiliency.spi.SPI;
import com.liferay.portal.kernel.resiliency.spi.SPIUtil;
import com.liferay.portal.kernel.security.pacl.permission.PortalMessageBusPermission;
import com.liferay.portal.kernel.util.ClassLoaderPool;
import com.liferay.portal.kernel.util.StringBundler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractMessagingConfigurator
implements MessagingConfigurator {
    private static Log _log = LogFactoryUtil.getLog(AbstractMessagingConfigurator.class);
    private List<Destination> _destinations = new ArrayList<Destination>();
    private List<DestinationEventListener> _globalDestinationEventListeners = new ArrayList<DestinationEventListener>();
    private Map<String, List<MessageListener>> _messageListeners = new HashMap<String, List<MessageListener>>();
    private boolean _portalMessagingConfigurator;
    private List<Destination> _replacementDestinations = new ArrayList<Destination>();
    private Map<String, List<DestinationEventListener>> _specificDestinationEventListeners = new HashMap<String, List<DestinationEventListener>>();

    /*
     * WARNING - void declaration
     */
    public void afterPropertiesSet() {
        ClassLoader operatingClassLoader;
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        if (contextClassLoader == (operatingClassLoader = this.getOperatingClassloader())) {
            this._portalMessagingConfigurator = true;
        }
        MessageBus messageBus = this.getMessageBus();
        for (DestinationEventListener destinationEventListener : this._globalDestinationEventListeners) {
            messageBus.addDestinationEventListener(destinationEventListener);
        }
        for (Destination destination : this._destinations) {
            void var5_10;
            if (SPIUtil.isSPI()) {
                IntrabandBridgeDestination intrabandBridgeDestination = new IntrabandBridgeDestination(destination);
            }
            messageBus.addDestination((Destination)var5_10);
        }
        for (Map.Entry entry : this._specificDestinationEventListeners.entrySet()) {
            String destinationName = (String)entry.getKey();
            for (DestinationEventListener destinationEventListener : (List)entry.getValue()) {
                messageBus.addDestinationEventListener(destinationName, destinationEventListener);
            }
        }
        for (Destination destination : this._replacementDestinations) {
            messageBus.replace(destination);
        }
        this.connect();
        String string = ClassLoaderPool.getContextName(operatingClassLoader);
        MessagingConfiguratorRegistry.registerMessagingConfigurator(string, this);
    }

    @Override
    public void connect() {
        if (SPIUtil.isSPI() && this._portalMessagingConfigurator) {
            return;
        }
        MessageBus messageBus = this.getMessageBus();
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            ClassLoader operatingClassLoader = this.getOperatingClassloader();
            currentThread.setContextClassLoader(operatingClassLoader);
            for (Map.Entry<String, List<MessageListener>> messageListeners : this._messageListeners.entrySet()) {
                String destinationName = messageListeners.getKey();
                if (SPIUtil.isSPI()) {
                    SPI spi = SPIUtil.getSPI();
                    try {
                        RegistrationReference registrationReference = spi.getRegistrationReference();
                        IntrabandRPCUtil.execute(registrationReference, new DestinationConfigurationProcessCallable(destinationName));
                    }
                    catch (Exception e) {
                        StringBundler sb = new StringBundler();
                        sb.append("Unable to install ");
                        sb.append(DestinationConfigurationProcessCallable.class.getName());
                        sb.append(" on MPI for ");
                        sb.append(destinationName);
                        _log.error(sb.toString(), e);
                    }
                }
                for (MessageListener messageListener : messageListeners.getValue()) {
                    messageBus.registerMessageListener(destinationName, messageListener);
                }
            }
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    @Override
    public void destroy() {
        this.disconnect();
        MessageBus messageBus = this.getMessageBus();
        for (Destination destination : this._destinations) {
            messageBus.removeDestination(destination.getName());
            destination.close();
        }
        for (Map.Entry entry : this._specificDestinationEventListeners.entrySet()) {
            String destinationName = (String)entry.getKey();
            for (DestinationEventListener destinationEventListener : (List)entry.getValue()) {
                messageBus.removeDestinationEventListener(destinationName, destinationEventListener);
            }
        }
        for (DestinationEventListener destinationEventListener : this._globalDestinationEventListeners) {
            messageBus.removeDestinationEventListener(destinationEventListener);
        }
        ClassLoader classLoader = this.getOperatingClassloader();
        String servletContextName = ClassLoaderPool.getContextName(classLoader);
        MessagingConfiguratorRegistry.unregisterMessagingConfigurator(servletContextName, this);
    }

    @Override
    public void disconnect() {
        if (SPIUtil.isSPI() && this._portalMessagingConfigurator) {
            return;
        }
        MessageBus messageBus = this.getMessageBus();
        for (Map.Entry<String, List<MessageListener>> messageListeners : this._messageListeners.entrySet()) {
            String destinationName = messageListeners.getKey();
            for (MessageListener messageListener : messageListeners.getValue()) {
                messageBus.unregisterMessageListener(destinationName, messageListener);
            }
        }
    }

    @Override
    public void setDestinations(List<Destination> destinations) {
        for (Destination destination : destinations) {
            try {
                PortalMessageBusPermission.checkListen(destination.getName());
            }
            catch (SecurityException securityException) {
                if (!_log.isInfoEnabled()) continue;
                _log.info("Rejecting destination " + destination.getName());
                continue;
            }
            this._destinations.add(destination);
        }
    }

    @Override
    public void setGlobalDestinationEventListeners(List<DestinationEventListener> globalDestinationEventListeners) {
        this._globalDestinationEventListeners = globalDestinationEventListeners;
    }

    @Override
    public void setMessageListeners(Map<String, List<MessageListener>> messageListeners) {
        this._messageListeners = messageListeners;
        for (List<MessageListener> messageListenersList : this._messageListeners.values()) {
            for (MessageListener messageListener : messageListenersList) {
                Method setMessageBusMethod;
                Class<?> messageListenerClass = messageListener.getClass();
                try {
                    setMessageBusMethod = messageListenerClass.getMethod("setMessageBus", MessageBus.class);
                    setMessageBusMethod.setAccessible(true);
                    setMessageBusMethod.invoke((Object)messageListener, this.getMessageBus());
                }
                catch (Exception exception) {
                    try {
                        setMessageBusMethod = messageListenerClass.getDeclaredMethod("setMessageBus", MessageBus.class);
                        setMessageBusMethod.setAccessible(true);
                        setMessageBusMethod.invoke((Object)messageListener, this.getMessageBus());
                    }
                    catch (Exception exception2) {}
                }
            }
        }
    }

    @Override
    public void setReplacementDestinations(List<Destination> replacementDestinations) {
        this._replacementDestinations = replacementDestinations;
    }

    @Override
    public void setSpecificDestinationEventListener(Map<String, List<DestinationEventListener>> specificDestinationEventListeners) {
        this._specificDestinationEventListeners = specificDestinationEventListeners;
    }

    protected abstract MessageBus getMessageBus();

    protected abstract ClassLoader getOperatingClassloader();
}

