/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.backgroundtask.messaging;

import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatus;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusMessageTranslator;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusRegistryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;

public class BackgroundTaskStatusMessageListener
extends BaseMessageListener {
    private static Log _log = LogFactoryUtil.getLog(BackgroundTaskStatusMessageListener.class);
    private long _backgroundTaskId;
    private BackgroundTaskStatusMessageTranslator _backgroundTaskStatusMessageTranslator;

    public BackgroundTaskStatusMessageListener(long backgroundTaskId, BackgroundTaskStatusMessageTranslator backgroundTaskStatusMessageTranslator) {
        this._backgroundTaskId = backgroundTaskId;
        this._backgroundTaskStatusMessageTranslator = backgroundTaskStatusMessageTranslator;
    }

    protected void doReceive(Message message) throws Exception {
        long backgroundTaskId = message.getLong("backgroundTaskId");
        if (backgroundTaskId != this._backgroundTaskId) {
            return;
        }
        BackgroundTaskStatus backgroundTaskStatus = BackgroundTaskStatusRegistryUtil.getBackgroundTaskStatus((long)backgroundTaskId);
        if (backgroundTaskStatus == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to locate status for background task " + backgroundTaskId + " to process " + message));
            }
            return;
        }
        this._backgroundTaskStatusMessageTranslator.translate(backgroundTaskStatus, message);
    }
}

