/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.model.EventDefinition;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletApp;
import com.liferay.portal.model.PortletFilter;
import com.liferay.portal.model.PortletURLListener;
import com.liferay.portal.model.PublicRenderParameter;
import com.liferay.portal.model.SpriteImage;
import com.liferay.portal.model.impl.PublicRenderParameterImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class PortletAppImpl
implements PortletApp {
    private Map<String, String[]> _containerRuntimeOptions = new HashMap<String, String[]>();
    private String _contextPath = "";
    private Map<String, String> _customUserAttributes = new LinkedHashMap<String, String>();
    private String _defaultNamespace = "";
    private Set<EventDefinition> _eventDefinitions = new LinkedHashSet<EventDefinition>();
    private Set<PortletFilter> _portletFilters = new LinkedHashSet<PortletFilter>();
    private Map<String, PortletFilter> _portletFiltersByFilterName = new HashMap<String, PortletFilter>();
    private Set<Portlet> _portlets = new LinkedHashSet<Portlet>();
    private Set<PortletURLListener> _portletURLListeners = new LinkedHashSet<PortletURLListener>();
    private Map<String, PortletURLListener> _portletURLListenersByListenerClass = new HashMap<String, PortletURLListener>();
    private Map<String, PublicRenderParameter> _publicRenderParametersByIdentifier = new HashMap<String, PublicRenderParameter>();
    private String _servletContextName = "";
    private Set<String> _servletURLPatterns = new LinkedHashSet<String>();
    private Map<String, SpriteImage> _spriteImagesMap = new HashMap<String, SpriteImage>();
    private Set<String> _userAttributes = new LinkedHashSet<String>();
    private boolean _warFile;

    public PortletAppImpl(String servletContextName) {
        this._servletContextName = servletContextName;
        if (Validator.isNotNull((String)this._servletContextName)) {
            this._contextPath = "/".concat(this._servletContextName);
            this._warFile = true;
        } else {
            this._warFile = false;
        }
    }

    public void addEventDefinition(EventDefinition eventDefinition) {
        this._eventDefinitions.add(eventDefinition);
    }

    public void addPortlet(Portlet portlet) {
        this._portlets.add(portlet);
    }

    public void addPortletFilter(PortletFilter portletFilter) {
        this._portletFilters.add(portletFilter);
        this._portletFiltersByFilterName.put(portletFilter.getFilterName(), portletFilter);
    }

    public void addPortletURLListener(PortletURLListener portletURLListener) {
        this._portletURLListeners.add(portletURLListener);
        this._portletURLListenersByListenerClass.put(portletURLListener.getListenerClass(), portletURLListener);
    }

    public void addPublicRenderParameter(PublicRenderParameter publicRenderParameter) {
        this._publicRenderParametersByIdentifier.put(publicRenderParameter.getIdentifier(), publicRenderParameter);
    }

    public void addPublicRenderParameter(String identifier, QName qName) {
        PublicRenderParameterImpl publicRenderParameter = new PublicRenderParameterImpl(identifier, qName, this);
        this.addPublicRenderParameter(publicRenderParameter);
    }

    public void addServletURLPatterns(Set<String> servletURLPatterns) {
        this._servletURLPatterns.addAll(servletURLPatterns);
    }

    public Map<String, String[]> getContainerRuntimeOptions() {
        return this._containerRuntimeOptions;
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public Map<String, String> getCustomUserAttributes() {
        return this._customUserAttributes;
    }

    public String getDefaultNamespace() {
        return this._defaultNamespace;
    }

    public Set<EventDefinition> getEventDefinitions() {
        return this._eventDefinitions;
    }

    public PortletFilter getPortletFilter(String filterName) {
        return this._portletFiltersByFilterName.get(filterName);
    }

    public Set<PortletFilter> getPortletFilters() {
        return this._portletFilters;
    }

    public List<Portlet> getPortlets() {
        return new ArrayList<Portlet>(this._portlets);
    }

    public PortletURLListener getPortletURLListener(String listenerClass) {
        return this._portletURLListenersByListenerClass.get(listenerClass);
    }

    public Set<PortletURLListener> getPortletURLListeners() {
        return this._portletURLListeners;
    }

    public PublicRenderParameter getPublicRenderParameter(String identifier) {
        return this._publicRenderParametersByIdentifier.get(identifier);
    }

    public String getServletContextName() {
        return this._servletContextName;
    }

    public Set<String> getServletURLPatterns() {
        return this._servletURLPatterns;
    }

    public SpriteImage getSpriteImage(String fileName) {
        return this._spriteImagesMap.get(fileName);
    }

    public Set<String> getUserAttributes() {
        return this._userAttributes;
    }

    public boolean isWARFile() {
        return this._warFile;
    }

    public void setDefaultNamespace(String defaultNamespace) {
        this._defaultNamespace = defaultNamespace;
    }

    public void setSpriteImages(String spriteFileName, Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            int[] values = StringUtil.split((String)value, (int)0);
            int offset = values[0];
            int height = values[1];
            int width = values[2];
            SpriteImage spriteImage = new SpriteImage(spriteFileName, key, offset, height, width);
            this._spriteImagesMap.put(key, spriteImage);
        }
    }

    public void setWARFile(boolean warFile) {
        this._warFile = warFile;
    }
}

