/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.cluster.FutureClusterResponses;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.ProgressTracker;
import com.liferay.portal.spring.context.PortalContextLoaderLifecycleThreadLocal;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.store.DLStoreUtil;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.concurrent.TimeUnit;

public class JarUtil {
    private static final String _FILE_PATH = "jar_temp/";
    private static final long _REPOSITORY = 0L;
    private static Log _log = LogFactoryUtil.getLog(JarUtil.class);
    private static MethodKey _installJarKey = new MethodKey(JarUtil.class, "installJar", new Class[]{Boolean.TYPE, String.class});

    public static void downloadAndInstallJar(boolean globalClassPath, String url, String name, ProgressTracker progressTracker) throws Exception {
        JarUtil.setProgressStatus(progressTracker, 1);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Downloading " + url));
        }
        byte[] bytes = HttpUtil.URLtoByteArray((String)url);
        JarUtil.setProgressStatus(progressTracker, 2);
        if (PropsValues.CLUSTER_LINK_ENABLED && !PortalContextLoaderLifecycleThreadLocal.isInitializing()) {
            try {
                DLStoreUtil.deleteFile((long)0L, (long)0L, (String)(_FILE_PATH + name));
            }
            catch (Exception exception) {}
            DLStoreUtil.addFile((long)0L, (long)0L, (String)(_FILE_PATH + name), (byte[])bytes);
            try {
                ClusterRequest clusterRequest = ClusterRequest.createMulticastRequest((MethodHandler)new MethodHandler(_installJarKey, new Object[]{globalClassPath, name}));
                FutureClusterResponses futureClusterResponses = ClusterExecutorUtil.execute((ClusterRequest)clusterRequest);
                futureClusterResponses.get(30L, TimeUnit.SECONDS);
            }
            catch (Throwable throwable) {
                try {
                    DLStoreUtil.deleteFile((long)0L, (long)0L, (String)(_FILE_PATH + name));
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                DLStoreUtil.deleteFile((long)0L, (long)0L, (String)(_FILE_PATH + name));
            }
            catch (Exception exception) {}
        } else {
            JarUtil.setProgressStatus(progressTracker, 2);
            JarUtil.installJar(bytes, globalClassPath, name);
        }
    }

    public static void installJar(boolean globalClassPath, String name) throws Exception {
        JarUtil.installJar(null, globalClassPath, name);
    }

    protected static void addJarFileToClassLoader(File file) throws Exception {
        Class<URLClassLoader> clazz = URLClassLoader.class;
        Method method = clazz.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        URI uri = file.toURI();
        method.invoke((Object)ClassLoader.getSystemClassLoader(), uri.toURL());
    }

    protected static void installJar(byte[] bytes, boolean globalClassPath, String name) throws Exception {
        String libPath = PropsValues.LIFERAY_LIB_PORTAL_DIR;
        if (globalClassPath) {
            libPath = PropsValues.LIFERAY_LIB_GLOBAL_DIR;
        }
        File file = new File(String.valueOf(libPath) + "/" + name);
        InputStream is = null;
        try {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Writing " + file));
            }
            if (bytes != null) {
                FileUtil.write((File)file, (byte[])bytes);
            } else {
                is = DLStoreUtil.getFileAsStream((long)0L, (long)0L, (String)(_FILE_PATH + name));
                FileUtil.write((File)file, (InputStream)is);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        JarUtil.addJarFileToClassLoader(file);
    }

    protected static void setProgressStatus(ProgressTracker progressTracker, int status) {
        if (progressTracker == null) {
            return;
        }
        progressTracker.setStatus(status);
    }
}

