/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.plugin;

import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.plugin.AbstractReferralPlugin;
import com.ecyrd.jspwiki.plugin.PluginException;
import com.ecyrd.jspwiki.plugin.WikiPlugin;
import com.ecyrd.jspwiki.providers.ProviderException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.span;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexPlugin
extends AbstractReferralPlugin
implements WikiPlugin {
    private static Logger log = Logger.getLogger(IndexPlugin.class);

    @Override
    public String execute(WikiContext context, Map params) throws PluginException {
        String include = (String)params.get("include");
        String exclude = (String)params.get("exclude");
        div masterDiv = new div();
        masterDiv.setClass("index");
        div indexDiv = new div();
        masterDiv.addElement((Element)indexDiv);
        indexDiv.setClass("header");
        try {
            List<String> pages = this.listPages(context, include, exclude);
            context.getEngine().getPageSorter().sort(pages);
            char initialChar = ' ';
            div currentDiv = new div();
            for (String name : pages) {
                if (name.charAt(0) != initialChar) {
                    if (initialChar != ' ') {
                        indexDiv.addElement(" - ");
                    }
                    initialChar = name.charAt(0);
                    masterDiv.addElement(this.makeHeader(initialChar));
                    currentDiv = new div();
                    currentDiv.setClass("body");
                    masterDiv.addElement((Element)currentDiv);
                    indexDiv.addElement("<a href='#" + initialChar + "'>" + initialChar + "</a>");
                } else {
                    currentDiv.addElement(", ");
                }
                String link = "<a href='" + context.getURL(WikiContext.VIEW, name) + "'>" + name + "</a>";
                currentDiv.addElement(link);
            }
        }
        catch (ProviderException e) {
            log.warn((Object)"Could not load page index", (Throwable)e);
            throw new PluginException(e.getMessage());
        }
        return masterDiv.toString();
    }

    private Element makeHeader(char initialChar) {
        span s = new span();
        s.setClass("section");
        s.addElement("<a name='" + initialChar + "'>" + initialChar + "</a>");
        return s;
    }

    private List<String> listPages(WikiContext context, String include, String exclude) throws ProviderException {
        Pattern includePtrn = include != null ? Pattern.compile(include) : Pattern.compile(".*");
        Pattern excludePtrn = exclude != null ? Pattern.compile(exclude) : Pattern.compile("\\p{Cntrl}");
        ArrayList<String> result = new ArrayList<String>();
        Set pages = context.getEngine().getReferenceManager().findCreated();
        for (String pageName : pages) {
            if (excludePtrn.matcher(pageName).matches() || !includePtrn.matcher(pageName).matches()) continue;
            result.add(pageName);
        }
        return result;
    }
}

