/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.PasswordExpiredException;
import com.liferay.portal.UserLockoutException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.AuthException;
import com.liferay.portal.security.auth.AuthSettingsUtil;
import com.liferay.portal.security.auth.Authenticator;
import com.liferay.portal.security.auth.LDAPAuthResult;
import com.liferay.portal.security.ldap.LDAPSettingsUtil;
import com.liferay.portal.security.ldap.PortalLDAPImporterUtil;
import com.liferay.portal.security.ldap.PortalLDAPUtil;
import com.liferay.portal.security.pwd.PasswordEncryptorUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.admin.util.OmniadminUtil;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;

public class LDAPAuth
implements Authenticator {
    public static final String AUTH_METHOD_BIND = "bind";
    public static final String AUTH_METHOD_PASSWORD_COMPARE = "password-compare";
    public static final String RESULT_PASSWORD_EXP_WARNING = "2.16.840.1.113730.3.4.5";
    public static final String RESULT_PASSWORD_RESET = "2.16.840.1.113730.3.4.4";
    private static Log _log = LogFactoryUtil.getLog(LDAPAuth.class);
    private ThreadLocal<Map<String, LDAPAuthResult>> _failedLDAPAuthResults = new AutoResetThreadLocal(LDAPAuth.class + "._failedLDAPAuthResultCache", new HashMap());

    public int authenticateByEmailAddress(long companyId, String emailAddress, String password, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        try {
            return this.authenticate(companyId, emailAddress, "", 0L, password);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new AuthException((Throwable)e2);
        }
    }

    public int authenticateByScreenName(long companyId, String screenName, String password, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        try {
            return this.authenticate(companyId, "", screenName, 0L, password);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new AuthException((Throwable)e2);
        }
    }

    public int authenticateByUserId(long companyId, long userId, String password, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        try {
            return this.authenticate(companyId, "", "", userId, password);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new AuthException((Throwable)e2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected LDAPAuthResult authenticate(LdapContext ctx, long companyId, Attributes attributes, String userDN, String password) throws Exception {
        LDAPAuthResult ldapAuthResult = null;
        String authMethod = PrefsPropsUtil.getString(companyId, "ldap.auth.method");
        if (authMethod.equals(AUTH_METHOD_BIND)) {
            Hashtable<String, Object> env = ctx.getEnvironment();
            env.put("java.naming.security.principal", userDN);
            env.put("java.naming.security.credentials", password);
            env.put("java.naming.referral", PrefsPropsUtil.getString(companyId, "ldap.referral"));
            env.put("com.sun.jndi.ldap.connect.pool", "false");
            ldapAuthResult = this.getFailedLDAPAuthResult(env);
            if (ldapAuthResult != null) {
                return ldapAuthResult;
            }
            ldapAuthResult = new LDAPAuthResult();
            InitialContext initialLdapContext = null;
            try {
                try {
                    initialLdapContext = new InitialLdapContext(env, null);
                    Control[] responseControls = ((InitialLdapContext)initialLdapContext).getResponseControls();
                    ldapAuthResult.setAuthenticated(true);
                    ldapAuthResult.setResponseControl(responseControls);
                    return ldapAuthResult;
                }
                catch (Exception e2) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Failed to bind to the LDAP server with userDN " + userDN + " and password " + password), (Throwable)e2);
                    }
                    ldapAuthResult.setAuthenticated(false);
                    ldapAuthResult.setErrorMessage(e2.getMessage());
                    this.setFailedLDAPAuthResult(env, ldapAuthResult);
                    if (initialLdapContext == null) return ldapAuthResult;
                    initialLdapContext.close();
                }
                return ldapAuthResult;
            }
            finally {
                if (initialLdapContext != null) {
                    initialLdapContext.close();
                }
            }
        } else {
            if (!authMethod.equals(AUTH_METHOD_PASSWORD_COMPARE)) return ldapAuthResult;
            ldapAuthResult = new LDAPAuthResult();
            Attribute userPassword = attributes.get("userPassword");
            if (userPassword == null) return ldapAuthResult;
            String ldapPassword = new String((byte[])userPassword.get());
            String encryptedPassword = password;
            String algorithm = PrefsPropsUtil.getString(companyId, "ldap.auth.password.encryption.algorithm");
            if (Validator.isNotNull((String)algorithm)) {
                encryptedPassword = PasswordEncryptorUtil.encrypt(algorithm, password, ldapPassword);
            }
            if (ldapPassword.equals(encryptedPassword)) {
                ldapAuthResult.setAuthenticated(true);
                return ldapAuthResult;
            } else {
                ldapAuthResult.setAuthenticated(false);
                if (!_log.isDebugEnabled()) return ldapAuthResult;
                _log.debug((Object)("Passwords do not match for userDN " + userDN));
            }
        }
        return ldapAuthResult;
    }

    protected int authenticate(long ldapServerId, long companyId, String emailAddress, String screenName, long userId, String password) throws Exception {
        block18: {
            String postfix = LDAPSettingsUtil.getPropertyPostfix(ldapServerId);
            LdapContext ldapContext = PortalLDAPUtil.getContext(ldapServerId, companyId);
            if (ldapContext == null) {
                return -1;
            }
            NamingEnumeration<SearchResult> enu = null;
            try {
                String baseDN = PrefsPropsUtil.getString(companyId, "ldap.base.dn" + postfix);
                String filter = LDAPSettingsUtil.getAuthSearchFilter(ldapServerId, companyId, emailAddress, screenName, String.valueOf(userId));
                Properties userMappings = LDAPSettingsUtil.getUserMappings(ldapServerId, companyId);
                String userMappingsScreenName = GetterUtil.getString((String)userMappings.getProperty("screenName"));
                userMappingsScreenName = StringUtil.toLowerCase((String)userMappingsScreenName);
                SearchControls searchControls = new SearchControls(2, 1L, 0, new String[]{userMappingsScreenName}, false, false);
                enu = ldapContext.search(baseDN, filter, searchControls);
                if (enu.hasMoreElements()) {
                    SearchResult result;
                    String fullUserDN;
                    Attributes attributes;
                    LDAPAuthResult ldapAuthResult;
                    String errorMessage;
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)"Search filter returned at least one result");
                    }
                    if ((errorMessage = (ldapAuthResult = this.authenticate(ldapContext, companyId, attributes = PortalLDAPUtil.getUserAttributes(ldapServerId, companyId, ldapContext, fullUserDN = PortalLDAPUtil.getNameInNamespace(ldapServerId, companyId, result = (SearchResult)enu.nextElement())), fullUserDN, password)).getErrorMessage()) != null) {
                        int pos = errorMessage.indexOf(PrefsPropsUtil.getString(companyId, "ldap.error.user.lockout"));
                        if (pos != -1) {
                            throw new UserLockoutException();
                        }
                        pos = errorMessage.indexOf(PrefsPropsUtil.getString(companyId, "ldap.error.password.expired"));
                        if (pos != -1) {
                            throw new PasswordExpiredException();
                        }
                    }
                    if (!ldapAuthResult.isAuthenticated()) {
                        return -1;
                    }
                    User user = PortalLDAPImporterUtil.importLDAPUser((long)ldapServerId, (long)companyId, (LdapContext)ldapContext, (Attributes)attributes, (String)password);
                    String resultCode = ldapAuthResult.getResponseControl();
                    if (resultCode.equals(RESULT_PASSWORD_RESET)) {
                        UserLocalServiceUtil.updatePasswordReset((long)user.getUserId(), (boolean)true);
                    }
                    break block18;
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Search filter did not return any results");
                }
                return 0;
            }
            catch (Exception e2) {
                if (e2 instanceof PasswordExpiredException || e2 instanceof UserLockoutException) {
                    throw e2;
                }
                _log.error((Object)"Problem accessing LDAP server", (Throwable)e2);
                return -1;
            }
            finally {
                if (enu != null) {
                    enu.close();
                }
                if (ldapContext != null) {
                    ldapContext.close();
                }
            }
        }
        return 1;
    }

    protected int authenticate(long companyId, String emailAddress, String screenName, long userId, String password) throws Exception {
        String postfix;
        String providerUrl;
        long[] ldapServerIds;
        int preferredLDAPServerResult;
        if (!AuthSettingsUtil.isLDAPAuthEnabled(companyId)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Authenticator is not enabled");
            }
            return 1;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Authenticator is enabled");
        }
        if ((preferredLDAPServerResult = this.authenticateAgainstPreferredLDAPServer(companyId, emailAddress, screenName, userId, password)) == 1) {
            if (PrefsPropsUtil.getBoolean(companyId, "ldap.import.user.password.enabled")) {
                return preferredLDAPServerResult;
            }
            return 2;
        }
        long[] lArray = ldapServerIds = StringUtil.split((String)PrefsPropsUtil.getString(companyId, "ldap.server.ids"), (long)0L);
        int n = ldapServerIds.length;
        int n2 = 0;
        while (n2 < n) {
            long ldapServerId = lArray[n2];
            int result = this.authenticate(ldapServerId, companyId, emailAddress, screenName, userId, password);
            if (result == 1) {
                if (PrefsPropsUtil.getBoolean(companyId, "ldap.import.user.password.enabled")) {
                    return result;
                }
                return 2;
            }
            ++n2;
        }
        int ldapServerId = 0;
        while (!Validator.isNull((String)(providerUrl = PrefsPropsUtil.getString(companyId, "ldap.base.provider.url" + (postfix = LDAPSettingsUtil.getPropertyPostfix(ldapServerId)))))) {
            int result = this.authenticate(ldapServerId, companyId, emailAddress, screenName, userId, password);
            if (result == 1) {
                if (PrefsPropsUtil.getBoolean(companyId, "ldap.import.user.password.enabled")) {
                    return result;
                }
                return 2;
            }
            ++ldapServerId;
        }
        return this.authenticateRequired(companyId, userId, emailAddress, screenName, true, -1);
    }

    protected int authenticateAgainstPreferredLDAPServer(long companyId, String emailAddress, String screenName, long userId, String password) throws Exception {
        User user;
        int result;
        block10: {
            result = 0;
            user = null;
            try {
                if (userId > 0L) {
                    user = UserLocalServiceUtil.getUserById((long)companyId, (long)userId);
                    break block10;
                }
                if (Validator.isNotNull((String)emailAddress)) {
                    user = UserLocalServiceUtil.getUserByEmailAddress((long)companyId, (String)emailAddress);
                    break block10;
                }
                if (Validator.isNotNull((String)screenName)) {
                    user = UserLocalServiceUtil.getUserByScreenName((long)companyId, (String)screenName);
                    break block10;
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Unable to get preferred LDAP server");
                }
                return result;
            }
            catch (NoSuchUserException nsue) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Unable to get preferred LDAP server", (Throwable)nsue);
                }
                return result;
            }
        }
        long ldapServerId = user.getLdapServerId();
        if (ldapServerId < 0L) {
            return result;
        }
        String postfix = LDAPSettingsUtil.getPropertyPostfix(ldapServerId);
        String providerUrl = PrefsPropsUtil.getString(user.getCompanyId(), "ldap.base.provider.url" + postfix);
        if (Validator.isNull((String)providerUrl)) {
            return result;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Using LDAP server ID " + ldapServerId + " to authenticate user " + user.getUserId()));
        }
        result = this.authenticate(ldapServerId, companyId, emailAddress, screenName, userId, password);
        return result;
    }

    protected int authenticateOmniadmin(long companyId, String emailAddress, String screenName, long userId) throws Exception {
        User user;
        if (!PropsValues.AUTH_PIPELINE_ENABLE_LIFERAY_CHECK) {
            return -1;
        }
        if (userId > 0L ? OmniadminUtil.isOmniadmin(userId) : (Validator.isNotNull((String)emailAddress) ? (user = UserLocalServiceUtil.fetchUserByEmailAddress((long)companyId, (String)emailAddress)) != null && OmniadminUtil.isOmniadmin(user) : Validator.isNotNull((String)screenName) && (user = UserLocalServiceUtil.fetchUserByScreenName((long)companyId, (String)screenName)) != null && OmniadminUtil.isOmniadmin(user))) {
            return 1;
        }
        return -1;
    }

    protected int authenticateRequired(long companyId, long userId, String emailAddress, String screenName, boolean allowOmniadmin, int failureCode) throws Exception {
        if (allowOmniadmin && this.authenticateOmniadmin(companyId, emailAddress, screenName, userId) == 1) {
            return 1;
        }
        if (PrefsPropsUtil.getBoolean(companyId, "ldap.auth.required")) {
            return failureCode;
        }
        return 1;
    }

    protected LDAPAuthResult getFailedLDAPAuthResult(Map<String, Object> env) {
        Map<String, LDAPAuthResult> failedLDAPAuthResults = this._failedLDAPAuthResults.get();
        String cacheKey = this.getKey(env);
        return failedLDAPAuthResults.get(cacheKey);
    }

    protected String getKey(Map<String, Object> env) {
        StringBundler sb = new StringBundler(5);
        sb.append(MapUtil.getString(env, (String)"java.naming.provider.url"));
        sb.append("#");
        sb.append(MapUtil.getString(env, (String)"java.naming.security.principal"));
        sb.append("#");
        sb.append(MapUtil.getString(env, (String)"java.naming.security.credentials"));
        return sb.toString();
    }

    protected void setFailedLDAPAuthResult(Map<String, Object> env, LDAPAuthResult ldapAuthResult) {
        String cacheKey;
        Map<String, LDAPAuthResult> failedLDAPAuthResults = this._failedLDAPAuthResults.get();
        if (failedLDAPAuthResults.containsKey(cacheKey = this.getKey(env))) {
            return;
        }
        failedLDAPAuthResults.put(cacheKey, ldapAuthResult);
    }
}

