/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.sso.ntlm;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.security.auth.AuthSettingsUtil;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.util.PortalInstances;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jcifs.ntlmssp.Type1Message;
import jcifs.ntlmssp.Type2Message;
import jcifs.util.Base64;

public class NtlmPostFilter
extends BasePortalFilter {
    private static Log _log = LogFactoryUtil.getLog(NtlmPostFilter.class);

    @Override
    protected Log getLog() {
        return _log;
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        byte[] src;
        String authorization;
        long companyId = PortalInstances.getCompanyId(request);
        if (AuthSettingsUtil.isNtlmEnabled(companyId) && BrowserSnifferUtil.isIe((HttpServletRequest)request) && request.getMethod().equals("POST") && (authorization = GetterUtil.getString((String)request.getHeader("Authorization"))).startsWith("NTLM ") && (src = Base64.decode((String)authorization.substring(5)))[8] == 1) {
            Type1Message type1 = new Type1Message(src);
            Type2Message type2 = new Type2Message(type1, new byte[8], null);
            authorization = Base64.encode((byte[])type2.toByteArray());
            response.setHeader("WWW-Authenticate", "NTLM " + authorization);
            response.setStatus(401);
            response.setContentLength(0);
            response.flushBuffer();
            return;
        }
        this.processFilter(NtlmPostFilter.class, request, response, filterChain);
    }
}

