/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.bundle;

import java.sql.SQLException;
import java.sql.Statement;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.persistence.PMContext;
import org.apache.jackrabbit.core.persistence.bundle.BundleDbPersistenceManager;

public class H2PersistenceManager
extends BundleDbPersistenceManager {
    private long lockTimeout = 10000L;

    public String getLockTimeout() {
        return String.valueOf(this.lockTimeout);
    }

    public void setLockTimeout(String lockTimeout) {
        this.lockTimeout = Long.parseLong(lockTimeout);
    }

    public void init(PMContext context) throws Exception {
        if (this.getDriver() == null) {
            this.setDriver("org.h2.Driver");
        }
        if (this.getUrl() == null) {
            this.setUrl("jdbc:h2:file:" + context.getHomeDir().getPath() + "/db/itemState");
        }
        if (this.getDatabaseType() == null) {
            this.setDatabaseType("h2");
        }
        if (this.getSchemaObjectPrefix() == null) {
            this.setSchemaObjectPrefix("");
        }
        super.init(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkSchema() throws SQLException, RepositoryException {
        Statement stmt = this.connectionManager.getConnection().createStatement();
        try {
            stmt.execute("SET LOCK_TIMEOUT " + this.lockTimeout);
        }
        finally {
            stmt.close();
        }
        super.checkSchema();
    }
}

