/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.lexer.yacc;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jcodings.Encoding;
import org.jruby.lexer.yacc.ByteArrayLexerSource;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.InputStreamLexerSource;
import org.jruby.lexer.yacc.SimplePositionFactory;
import org.jruby.parser.ParserConfiguration;
import org.jruby.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LexerSource {
    private SimplePositionFactory positionFactory;
    private final String sourceName;
    protected int line = 0;
    protected int lineOffset = 0;
    protected int offset = 0;
    private List<String> list;
    private StringBuilder lineBuffer;
    private StringBuilder sourceLine;

    protected LexerSource(String sourceName, List<String> list2, int lineOffset, boolean extraPositionInformation) {
        this.sourceName = sourceName;
        this.lineOffset = lineOffset;
        this.positionFactory = new SimplePositionFactory(this, this.line);
        this.list = list2;
        this.lineBuffer = new StringBuilder(160);
        this.sourceLine = new StringBuilder(160);
    }

    public String getFilename() {
        return this.sourceName;
    }

    public int getLine() {
        return this.line;
    }

    public int getVirtualLine() {
        return this.line + this.lineOffset;
    }

    public int getOffset() {
        return this.offset <= 0 ? 0 : this.offset;
    }

    public ISourcePosition getPosition(ISourcePosition startPosition) {
        return this.positionFactory.getPosition(startPosition);
    }

    public ISourcePosition getPosition() {
        return this.positionFactory.getPosition(null);
    }

    public static LexerSource getSource(String name2, InputStream content, List<String> list2, ParserConfiguration configuration) {
        return new InputStreamLexerSource(name2, content, list2, configuration.getLineNumber(), configuration.hasExtraPositionInformation());
    }

    public static LexerSource getSource(String name2, byte[] content, List<String> list2, ParserConfiguration configuration) {
        return new ByteArrayLexerSource(name2, content, list2, configuration.getLineNumber(), configuration.hasExtraPositionInformation());
    }

    private void captureFeatureNewline() {
        StringBuilder temp = this.sourceLine;
        this.sourceLine = this.lineBuffer;
        if (this.list != null && this.lineBuffer.length() > 0) {
            this.list.add(this.sourceLine.toString());
        }
        temp.setLength(0);
        this.lineBuffer = temp;
    }

    protected void captureFeature(int c) {
        switch (c) {
            case 10: {
                this.lineBuffer.append((char)c);
            }
            case -1: {
                this.captureFeatureNewline();
                break;
            }
            default: {
                this.lineBuffer.append((char)c);
            }
        }
    }

    protected void uncaptureFeature(int c) {
        int end2 = this.lineBuffer.length() - 1;
        if (end2 >= 0 && this.lineBuffer.charAt(end2) == c) {
            this.lineBuffer.deleteCharAt(end2);
        } else if (c == 10 && this.list != null && !this.list.isEmpty()) {
            this.lineBuffer = new StringBuilder(this.list.remove(this.list.size() - 1));
            end2 = this.lineBuffer.length() - 1;
            if (this.lineBuffer.charAt(end2) == '\n') {
                this.lineBuffer.deleteCharAt(end2);
            }
        }
    }

    public String getCurrentLine() {
        int errorLocation = this.lineBuffer.length() - 1;
        try {
            this.readLineBytes();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.sourceLine.toString() + this.makePointer(errorLocation);
    }

    protected String makePointer(int length2) {
        StringBuilder buf = new StringBuilder();
        for (int i2 = 0; i2 < length2; ++i2) {
            buf.append(' ');
        }
        buf.append('^');
        return buf.toString();
    }

    public int readCodepoint(int first2, Encoding encoding2) throws IOException {
        int c;
        int count2 = 0;
        byte[] value2 = new byte[6];
        value2[0] = (byte)first2;
        for (count2 = 1; count2 < 6 && (c = this.read()) != -1; ++count2) {
            value2[count2] = (byte)c;
        }
        int length2 = encoding2.length(value2, 0, count2);
        if (length2 < 0) {
            return -2;
        }
        int codepoint = encoding2.mbcToCode(value2, 0, length2);
        for (int i2 = count2 - 1; i2 >= length2; --i2) {
            this.unread(value2[i2]);
        }
        return codepoint;
    }

    public abstract boolean matchMarker(ByteList var1, boolean var2, boolean var3) throws IOException;

    public abstract int read() throws IOException;

    public abstract ByteList readUntil(char var1) throws IOException;

    public abstract ByteList readLineBytes() throws IOException;

    public abstract int skipUntil(int var1) throws IOException;

    public abstract void unread(int var1);

    public abstract void unreadMany(CharSequence var1);

    public abstract boolean peek(int var1) throws IOException;

    public abstract boolean lastWasBeginOfLine();

    public abstract boolean wasBeginOfLine();

    public abstract InputStream getRemainingAsStream() throws IOException;
}

