/*
 * Decompiled with CFR 0.152.
 */
package jodd.servlet;

import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;

public class RequestContextListener
implements ServletRequestListener {
    private static final ThreadLocal<HttpServletRequest> requestHolder = new InheritableThreadLocal<HttpServletRequest>();

    public void requestInitialized(ServletRequestEvent requestEvent) {
        if (!(requestEvent.getServletRequest() instanceof HttpServletRequest)) {
            throw new IllegalArgumentException("Request is not an HttpServletRequest: " + requestEvent.getServletRequest());
        }
        HttpServletRequest request = (HttpServletRequest)requestEvent.getServletRequest();
        requestHolder.set(request);
    }

    public void requestDestroyed(ServletRequestEvent servletRequestEvent) {
        requestHolder.set(null);
    }

    public static HttpServletRequest getRequest() {
        return requestHolder.get();
    }
}

