/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.util;

import java.io.Serializable;
import java.lang.reflect.Array;

public abstract class PrimitiveMatrix
implements Serializable {
    protected Object _matrix;
    protected int _rowCount;
    protected int _colCount;
    private int _growth;
    private int[] _dim;
    private transient Class _type;
    private static final int DEFAULT_SIZE = 1000;

    protected PrimitiveMatrix(Class type, int[] sizes) {
        this._type = type;
        if (sizes == null || sizes.length != 2) {
            throw new IllegalArgumentException("Invalid dimension specified.");
        }
        if (sizes[0] <= 0 || sizes[1] <= 0) {
            throw new IllegalArgumentException("Invalid size specified.");
        }
        this._matrix = Array.newInstance(type, sizes);
        this._rowCount = 0;
        this._colCount = 0;
        this._growth = 10;
        this._dim = sizes;
    }

    protected PrimitiveMatrix(Class type) {
        this(type, new int[]{1000, 1000});
    }

    protected synchronized void expandRows(int upTo) {
        if (upTo <= this._dim[0]) {
            return;
        }
        int old = this._dim[0];
        this._dim[0] = upTo * this._growth;
        Object newMatrix = Array.newInstance(this._type, this._dim);
        for (int i = 0; i < old; ++i) {
            Object oldRow = Array.get(this._matrix, i);
            Object newRow = Array.get(newMatrix, i);
            System.arraycopy(oldRow, 0, newRow, 0, this._dim[1]);
        }
        this._growth *= 10;
        this._matrix = newMatrix;
    }

    protected synchronized void expandCols(int upTo) {
        if (upTo <= this._dim[1]) {
            return;
        }
        int old = this._dim[1];
        this._dim[1] = upTo * this._growth;
        Object newMatrix = Array.newInstance(this._type, this._dim);
        for (int i = 0; i < this._dim[0]; ++i) {
            Object oldRow = Array.get(this._matrix, i);
            Object newRow = Array.get(newMatrix, i);
            System.arraycopy(oldRow, 0, newRow, 0, old);
        }
        this._growth *= 10;
        this._matrix = newMatrix;
    }

    protected synchronized void expand(int rUpto, int cUpTo) {
        int[] newDim = new int[]{rUpto + this._growth, cUpTo + this._growth};
        Object newMatrix = Array.newInstance(this._type, newDim);
        for (int i = 0; i < this._dim[0]; ++i) {
            Object oldRow = Array.get(this._matrix, i);
            Object newRow = Array.get(newMatrix, i);
            System.arraycopy(oldRow, 0, newRow, 0, this._dim[1]);
        }
        this._matrix = newMatrix;
        this._dim = newDim;
        this._growth *= 10;
    }

    public void ensureCapacity(int x, int y) {
        this._rowCount = Math.max(x, this._rowCount);
        this._colCount = Math.max(y, this._colCount);
        if (this._rowCount >= this._dim[0] && this._colCount >= this._dim[1]) {
            this.expand(x, y);
        } else if (this._rowCount >= this._dim[0]) {
            this.expandRows(x);
        } else if (this._colCount >= this._dim[1]) {
            this.expandCols(y);
        }
    }

    public synchronized void seal() {
        if (this._dim[0] > this._rowCount || this._dim[1] > this._colCount) {
            int[] newDim = new int[]{this._dim[0], this._dim[1]};
            Object newMatrix = Array.newInstance(this._type, newDim);
            for (int i = 0; i < newDim[0]; ++i) {
                Object oldRow = Array.get(this._matrix, i);
                Object newRow = Array.get(newMatrix, i);
                System.arraycopy(oldRow, 0, newRow, 0, newDim[1]);
            }
            this._matrix = newMatrix;
            this._dim = newDim;
        }
        this._growth = 10;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("{");
        for (int i = 0; i <= this._rowCount; ++i) {
            if (i != 0) {
                buffer.append('\n');
            }
            Object row = Array.get(this._matrix, i);
            for (int j = 0; j <= this._colCount; ++j) {
                if (j != 0) {
                    buffer.append(", ");
                }
                buffer.append(Array.get(row, j));
            }
        }
        buffer.append('}');
        return buffer.toString();
    }
}

