/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.utils.properties;

import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterpolationHelper {
    private static final char ESCAPE_CHAR = '\\';
    private static final String DELIM_START = "${";
    private static final String DELIM_STOP = "}";

    private InterpolationHelper() {
    }

    public static void performSubstitution(Map<String, String> properties) {
        InterpolationHelper.performSubstitution(properties, null);
    }

    public static void performSubstitution(Map<String, String> properties, BundleContext context) {
        for (String name : properties.keySet()) {
            String value = properties.get(name);
            properties.put(name, InterpolationHelper.substVars(value, name, null, properties, context));
        }
    }

    public static String substVars(String val, String currentKey, Map<String, String> cycleMap, Map<String, String> configProps, BundleContext context) throws IllegalArgumentException {
        String substValue;
        int idx;
        if (cycleMap == null) {
            cycleMap = new HashMap<String, String>();
        }
        cycleMap.put(currentKey, currentKey);
        int stopDelim = val.indexOf(DELIM_STOP);
        while (stopDelim > 0 && val.charAt(stopDelim - 1) == '\\') {
            stopDelim = val.indexOf(DELIM_STOP, stopDelim + 1);
        }
        int startDelim = val.indexOf(DELIM_START);
        while (stopDelim >= 0 && (idx = val.indexOf(DELIM_START, startDelim + DELIM_START.length())) >= 0 && idx <= stopDelim) {
            if (idx >= stopDelim) continue;
            startDelim = idx;
        }
        if (startDelim < 0 || stopDelim < 0) {
            return InterpolationHelper.unescape(val);
        }
        String variable = val.substring(startDelim + DELIM_START.length(), stopDelim);
        if (cycleMap.get(variable) != null) {
            throw new IllegalArgumentException(new StringBuffer().append("recursive variable reference: ").append(variable).toString());
        }
        String string = substValue = configProps != null ? configProps.get(variable) : null;
        if (substValue == null) {
            if (variable.length() <= 0) {
                substValue = "";
            } else if (context != null) {
                substValue = context.getProperty(variable);
                if (substValue == null) {
                    substValue = "";
                }
            } else {
                substValue = System.getProperty(variable, "");
            }
        }
        cycleMap.remove(variable);
        val = new StringBuffer().append(val.substring(0, startDelim)).append(substValue).append(val.substring(stopDelim + DELIM_STOP.length(), val.length())).toString();
        val = InterpolationHelper.substVars(val, currentKey, cycleMap, configProps, context);
        val = InterpolationHelper.unescape(val);
        return val;
    }

    private static String unescape(String val) {
        int escape = val.indexOf(92);
        while (escape >= 0 && escape < val.length() - 1) {
            char c = val.charAt(escape + 1);
            if (c == '{' || c == '}' || c == '\\') {
                val = new StringBuffer().append(val.substring(0, escape)).append(val.substring(escape + 1)).toString();
            }
            escape = val.indexOf(92, escape + 1);
        }
        return val;
    }
}

