/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.propertiesdoc;

import com.liferay.portal.freemarker.FreeMarkerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.portal.tools.propertiesdoc.PropertiesSection;
import com.liferay.portal.tools.propertiesdoc.PropertyComment;
import com.liferay.portal.util.FileImpl;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PropertiesDocBuilder {
    protected static final String DOUBLE_INDENT = "        ";
    protected static final String INDENT = "    ";
    private static FileImpl _fileUtil = FileImpl.getInstance();

    public static void main(String[] args) {
        try {
            new PropertiesDocBuilder(args);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public PropertiesDocBuilder(String[] args) throws IOException {
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        String propertiesDestDirName = GetterUtil.getString((String)arguments.get("properties.dest.dir"));
        String propertiesFileName = GetterUtil.getString((String)arguments.get("properties.file"));
        String title = GetterUtil.getString((String)arguments.get("properties.title"));
        boolean toc = GetterUtil.getBoolean((String)arguments.get("properties.toc"));
        System.out.println("Converting " + propertiesFileName + " to HTML");
        File propertiesFile = new File(propertiesFileName);
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("pageTitle", title);
        int pos = propertiesFileName.lastIndexOf("/");
        if (pos != -1) {
            propertiesFileName = propertiesFileName.substring(pos + 1);
        }
        context.put("propertiesFileName", propertiesFileName);
        List<PropertiesSection> propertiesSections = this.getPropertiesSections(propertiesFile);
        if (propertiesSections == null) {
            return;
        }
        context.put("sections", propertiesSections);
        context.put("toc", toc);
        try {
            StringBundler sb = new StringBundler(4);
            sb.append(propertiesDestDirName);
            sb.append("/");
            sb.append(propertiesFileName);
            sb.append(".html");
            String propertiesHTMLFileName = sb.toString();
            File propertiesHTMLFile = new File(propertiesHTMLFileName);
            System.out.println("Writing " + propertiesHTMLFile);
            FileWriter writer = new FileWriter(propertiesHTMLFile);
            try {
                FreeMarkerUtil.process("com/liferay/portal/tools/propertiesdoc/dependencies/properties.ftl", context, writer);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            ((Writer)writer).flush();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    protected void addPropertyComment(List<PropertyComment> propertyComments, String comment) {
        if (Validator.isNotNull((String)comment)) {
            PropertyComment propertyComment = new PropertyComment(comment);
            propertyComments.add(propertyComment);
        }
    }

    protected List<String> extractComments(String[] lines) {
        ArrayList<String> comments = new ArrayList<String>();
        StringBundler sb = new StringBundler();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String trimmedLine = line.trim();
            if (trimmedLine.startsWith("## ")) {
                trimmedLine = trimmedLine.substring(2);
                sb.append(trimmedLine.trim());
            }
            if (trimmedLine.length() < 3 && sb.index() != 0) {
                comments.add(sb.toString());
                sb = new StringBundler();
            }
            ++n2;
        }
        return comments;
    }

    protected String extractDefaultProperties(String[] lines) {
        StringBundler sb = new StringBundler();
        boolean previousLineIsDefaultProperty = false;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (!previousLineIsDefaultProperty) {
                if (!line.startsWith("#") && !line.startsWith("    #")) {
                    previousLineIsDefaultProperty = true;
                    sb.append(line);
                    sb.append("\n");
                }
            } else if (line.startsWith("#") || line.startsWith("    #")) {
                previousLineIsDefaultProperty = false;
            } else {
                sb.append(line);
                sb.append("\n");
            }
            ++n2;
        }
        return sb.toString();
    }

    protected String extractExampleProperties(String[] lines) {
        StringBundler sb = new StringBundler();
        boolean previousLineIsExample = false;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String exampleProperty;
            String line = stringArray[n2];
            String trimmedLine = line.trim();
            if (!previousLineIsExample) {
                if (!line.startsWith("    # ") && !trimmedLine.equals("#") && line.startsWith("    #")) {
                    previousLineIsExample = true;
                    exampleProperty = String.valueOf(StringUtil.replaceFirst((String)line, (String)"#", (String)"")) + "\n";
                    sb.append(exampleProperty);
                }
            } else if (!trimmedLine.startsWith("#")) {
                previousLineIsExample = false;
            } else {
                exampleProperty = String.valueOf(line.replaceFirst("#", "")) + "\n";
                sb.append(exampleProperty);
            }
            ++n2;
        }
        return sb.toString();
    }

    protected List<PropertyComment> extractPropertyComments(String[] lines) {
        ArrayList<PropertyComment> propertyComments = new ArrayList<PropertyComment>();
        StringBundler sb = new StringBundler();
        boolean previousLineIsPreformatted = false;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if ((line = StringUtil.trimTrailing((String)line)).startsWith("        #")) break;
            String trimmedLine = line.trim();
            if (trimmedLine.startsWith("#     ")) {
                if (previousLineIsPreformatted) {
                    sb.append(StringUtil.replaceFirst((String)trimmedLine, (String)"#", (String)""));
                } else {
                    this.addPropertyComment(propertyComments, sb.toString());
                    sb = new StringBundler();
                    sb.append(StringUtil.replaceFirst((String)trimmedLine, (String)"#", (String)""));
                }
                sb.append("\n");
                previousLineIsPreformatted = true;
            } else if (trimmedLine.startsWith("# ")) {
                if (previousLineIsPreformatted) {
                    this.addPropertyComment(propertyComments, sb.toString());
                    sb = new StringBundler();
                    trimmedLine = StringUtil.replaceFirst((String)trimmedLine, (String)"#", (String)"");
                    sb.append(trimmedLine.trim());
                } else {
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    line = StringUtil.replaceFirst((String)line, (String)"#", (String)"");
                    sb.append(line.trim());
                }
                sb.append("\n");
                previousLineIsPreformatted = false;
            } else if (trimmedLine.startsWith("#") && trimmedLine.length() < 2) {
                this.addPropertyComment(propertyComments, sb.toString());
                sb = new StringBundler();
            } else {
                this.addPropertyComment(propertyComments, sb.toString());
                break;
            }
            ++n2;
        }
        return propertyComments;
    }

    protected String extractTitle(String[] lines) {
        if (lines == null || lines.length <= 1) {
            return null;
        }
        String title = lines[1];
        title = StringUtil.replaceFirst((String)title, (String)"##", (String)"");
        return title.trim();
    }

    protected int getLineCount(String sectionString) {
        String[] lines = sectionString.split("\r\n|\r|\n");
        return lines.length;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected List<PropertiesSection> getPropertiesSections(File propertiesFile) throws IOException {
        String content = _fileUtil.read(propertiesFile);
        String[] sections = content.split("\n\n");
        ArrayList<PropertiesSection> propertiesSections = new ArrayList<PropertiesSection>(sections.length);
        String[] stringArray = sections;
        int n = sections.length;
        int n2 = 0;
        while (n2 < n) {
            String section = stringArray[n2];
            section = StringUtil.trimLeading((String)section, (char)' ');
            PropertiesSection propertiesSection = new PropertiesSection(section);
            String[] lines = section.split("\n");
            if (section.startsWith("##")) {
                int lineCount = this.getLineCount(section);
                if (lineCount == 3) {
                    propertiesSection.setTitle(this.extractTitle(lines));
                    propertiesSections.add(propertiesSection);
                } else {
                    if (lineCount <= 3) {
                        StringBundler sb = new StringBundler(8);
                        sb.append("Properties section should consist of 3 ");
                        sb.append("or more lines:");
                        sb.append("\n");
                        sb.append("##");
                        sb.append("\n");
                        sb.append("## Comments");
                        sb.append("\n");
                        sb.append("##");
                        System.out.println(sb.toString());
                        return null;
                    }
                    propertiesSection.setComments(this.extractComments(lines));
                    propertiesSections.add(propertiesSection);
                }
            } else {
                propertiesSection.setDefaultProperties(this.extractDefaultProperties(lines));
                propertiesSection.setExampleProperties(this.extractExampleProperties(lines));
                propertiesSection.setPropertyComments(this.extractPropertyComments(lines));
                propertiesSections.add(propertiesSection);
            }
            ++n2;
        }
        return propertiesSections;
    }
}

