/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.softwarecatalog.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.softwarecatalog.model.SCProductEntry;
import com.liferay.portlet.softwarecatalog.service.SCProductEntryLocalServiceUtil;

public class SCProductEntryPermission {
    public static void check(PermissionChecker permissionChecker, long productEntryId, String actionId) throws PortalException, SystemException {
        if (!SCProductEntryPermission.contains(permissionChecker, productEntryId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, SCProductEntry productEntry, String actionId) throws PortalException {
        if (!SCProductEntryPermission.contains(permissionChecker, productEntry, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long productEntryId, String actionId) throws PortalException, SystemException {
        SCProductEntry productEntry = SCProductEntryLocalServiceUtil.getProductEntry((long)productEntryId);
        return SCProductEntryPermission.contains(permissionChecker, productEntry, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, SCProductEntry productEntry, String actionId) {
        if (permissionChecker.hasOwnerPermission(productEntry.getCompanyId(), SCProductEntry.class.getName(), productEntry.getProductEntryId(), productEntry.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(productEntry.getGroupId(), SCProductEntry.class.getName(), productEntry.getProductEntryId(), actionId);
    }
}

