/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.context;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;

public class WeakIdentityHashMap<K, V> {
    private final ReferenceQueue<K> referenceQueue = new ReferenceQueue();
    private final ConcurrentHashMap<Reference<K>, V> backing = new ConcurrentHashMap();

    public V get(K key) {
        this.clean();
        return this.backing.get(new IdentityWeakReference<K>(key));
    }

    public V putIfAbsent(K key, V value) {
        this.clean();
        return this.backing.putIfAbsent(new IdentityWeakReference<K>(key, this.referenceQueue), value);
    }

    private void clean() {
        Reference<K> ref;
        while ((ref = this.referenceQueue.poll()) != null) {
            this.backing.remove(ref);
        }
    }

    static class IdentityWeakReference<T>
    extends WeakReference<T> {
        private final int hashCode;

        public IdentityWeakReference(T t) {
            this(t, null);
        }

        public IdentityWeakReference(T t, ReferenceQueue<? super T> rq) {
            super(t, rq);
            this.hashCode = System.identityHashCode(t);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof IdentityWeakReference) {
                Object ourReferent = this.get();
                return ourReferent != null && ourReferent == ((IdentityWeakReference)o).get();
            }
            return false;
        }
    }
}

