/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatalists.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import com.liferay.portlet.dynamicdatalists.util.DDLExportFormat;
import com.liferay.portlet.dynamicdatalists.util.DDLExporter;
import java.util.HashMap;
import java.util.Map;

public class DDLExporterFactory {
    private static Map<DDLExportFormat, DDLExporter> _exporters;

    public static DDLExporter getDDLExporter(DDLExportFormat exportFormat) throws PortalException {
        DDLExporter exporter = _exporters.get((Object)exportFormat);
        if (exporter == null) {
            throw new PortalException("Invalid format type " + (Object)((Object)exportFormat));
        }
        return exporter;
    }

    public void setDDLExporters(Map<String, DDLExporter> exporters) {
        PortalRuntimePermission.checkSetBeanProperty(this.getClass());
        _exporters = new HashMap<DDLExportFormat, DDLExporter>();
        for (Map.Entry<String, DDLExporter> entry : exporters.entrySet()) {
            DDLExportFormat exportFormat = DDLExportFormat.parse(entry.getKey());
            _exporters.put(exportFormat, entry.getValue());
        }
    }
}

