/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.local;

import java.math.BigInteger;
import java.util.List;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.local.AbstractLocalService;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.server.CmisServiceFactory;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.commons.spi.ObjectService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectServiceImpl
extends AbstractLocalService
implements ObjectService {
    public ObjectServiceImpl(BindingSession session, CmisServiceFactory factory) {
        this.setSession(session);
        this.setServiceFactory(factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createDocument(String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            String string = service.createDocument(repositoryId, properties, folderId, contentStream, versioningState, policies, addAces, removeAces, extension);
            return string;
        }
        finally {
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createDocumentFromSource(String repositoryId, String sourceId, Properties properties, String folderId, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            String string = service.createDocumentFromSource(repositoryId, sourceId, properties, folderId, versioningState, policies, addAces, removeAces, extension);
            return string;
        }
        finally {
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createFolder(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            String string = service.createFolder(repositoryId, properties, folderId, policies, addAces, removeAces, extension);
            return string;
        }
        finally {
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createPolicy(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            String string = service.createPolicy(repositoryId, properties, folderId, policies, addAces, removeAces, extension);
            return string;
        }
        finally {
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createRelationship(String repositoryId, Properties properties, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            String string = service.createRelationship(repositoryId, properties, policies, addAces, removeAces, extension);
            return string;
        }
        finally {
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteContentStream(String repositoryId, Holder<String> objectId, Holder<String> changeToken, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            service.deleteContentStream(repositoryId, objectId, changeToken, extension);
        }
        finally {
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObject(String repositoryId, String objectId, Boolean allVersions, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            service.deleteObject(repositoryId, objectId, allVersions, extension);
        }
        finally {
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FailedToDeleteData deleteTree(String repositoryId, String folderId, Boolean allVersions, UnfileObject unfileObjects, Boolean continueOnFailure, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            FailedToDeleteData failedToDeleteData = service.deleteTree(repositoryId, folderId, allVersions, unfileObjects, continueOnFailure, extension);
            return failedToDeleteData;
        }
        finally {
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AllowableActions getAllowableActions(String repositoryId, String objectId, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            AllowableActions allowableActions = service.getAllowableActions(repositoryId, objectId, extension);
            return allowableActions;
        }
        finally {
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentStream getContentStream(String repositoryId, String objectId, String streamId, BigInteger offset, BigInteger length, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            ContentStream contentStream = service.getContentStream(repositoryId, objectId, streamId, offset, length, extension);
            return contentStream;
        }
        finally {
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectData getObject(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            ObjectData objectData = service.getObject(repositoryId, objectId, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, extension);
            return objectData;
        }
        finally {
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectData getObjectByPath(String repositoryId, String path, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            ObjectData objectData = service.getObjectByPath(repositoryId, path, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, extension);
            return objectData;
        }
        finally {
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getProperties(String repositoryId, String objectId, String filter, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            Properties properties = service.getProperties(repositoryId, objectId, filter, extension);
            return properties;
        }
        finally {
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RenditionData> getRenditions(String repositoryId, String objectId, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            List list = service.getRenditions(repositoryId, objectId, renditionFilter, maxItems, skipCount, extension);
            return list;
        }
        finally {
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveObject(String repositoryId, Holder<String> objectId, String targetFolderId, String sourceFolderId, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            service.moveObject(repositoryId, objectId, targetFolderId, sourceFolderId, extension);
        }
        finally {
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContentStream(String repositoryId, Holder<String> objectId, Boolean overwriteFlag, Holder<String> changeToken, ContentStream contentStream, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            service.setContentStream(repositoryId, objectId, overwriteFlag, changeToken, contentStream, extension);
        }
        finally {
            service.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProperties(String repositoryId, Holder<String> objectId, Holder<String> changeToken, Properties properties, ExtensionsData extension) {
        CmisService service = this.getService(repositoryId);
        try {
            service.updateProperties(repositoryId, objectId, changeToken, properties, extension);
        }
        finally {
            service.close();
        }
    }
}

