/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.parser;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import org.apache.commons.lang.ClassUtils;
import org.jamwiki.DataAccessException;
import org.jamwiki.Environment;
import org.jamwiki.WikiBase;
import org.jamwiki.model.Topic;
import org.jamwiki.parser.AbstractParser;
import org.jamwiki.parser.ParserException;
import org.jamwiki.parser.ParserInput;
import org.jamwiki.parser.ParserOutput;
import org.jamwiki.utils.WikiLogger;

public class ParserUtil {
    private static final WikiLogger logger = WikiLogger.getLogger(ParserUtil.class.getName());

    public static String parse(ParserInput parserInput, ParserOutput parserOutput, String content) throws ParserException {
        if (content == null) {
            return null;
        }
        if (parserOutput == null) {
            parserOutput = new ParserOutput();
        }
        AbstractParser parser = ParserUtil.parserInstance(parserInput);
        return parser.parseHTML(parserOutput, content);
    }

    public static ParserOutput parserOutput(String content, String virtualWiki, String topicName) throws ParserException {
        ParserInput parserInput = new ParserInput(virtualWiki, topicName);
        parserInput.setAllowSectionEdit(false);
        return ParserUtil.parseMetadata(parserInput, content);
    }

    public static ParserOutput parseMetadata(ParserInput parserInput, String content) throws ParserException {
        AbstractParser parser = ParserUtil.parserInstance(parserInput);
        ParserOutput parserOutput = new ParserOutput();
        parser.parseMetadata(parserOutput, content);
        return parserOutput;
    }

    public static String parseMinimal(ParserInput parserInput, String raw) throws ParserException {
        AbstractParser parser = ParserUtil.parserInstance(parserInput);
        return parser.parseMinimal(raw);
    }

    private static AbstractParser parserInstance(ParserInput parserInput) throws ParserException {
        String parserClass = Environment.getValue("parser");
        try {
            Class clazz = ClassUtils.getClass((String)parserClass);
            Class[] parameterTypes = new Class[]{ClassUtils.getClass((String)"org.jamwiki.parser.ParserInput")};
            Constructor constructor = clazz.getConstructor(parameterTypes);
            Object[] initArgs = new Object[]{parserInput};
            return (AbstractParser)constructor.newInstance(initArgs);
        }
        catch (ClassNotFoundException e) {
            throw new ParserException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ParserException(e);
        }
        catch (IllegalAccessException e) {
            throw new ParserException(e);
        }
        catch (InstantiationException e) {
            throw new ParserException(e);
        }
        catch (InvocationTargetException e) {
            throw new ParserException(e);
        }
    }

    public static String parserRedirectContent(String topicName) throws ParserException {
        AbstractParser parser = ParserUtil.parserInstance(null);
        return parser.buildRedirectContent(topicName);
    }

    public static String[] parseSlice(String context, Locale locale, String virtualWiki, String topicName, int section) throws ParserException {
        ParserOutput parserOutput = new ParserOutput();
        return ParserUtil.executeSliceOrSplice(parserOutput, context, locale, virtualWiki, topicName, section, null, true);
    }

    public static String[] parseSplice(ParserOutput parserOutput, String context, Locale locale, String virtualWiki, String topicName, int targetSection, String replacementText) throws ParserException {
        return ParserUtil.executeSliceOrSplice(parserOutput, context, locale, virtualWiki, topicName, targetSection, replacementText, false);
    }

    private static String[] executeSliceOrSplice(ParserOutput parserOutput, String context, Locale locale, String virtualWiki, String topicName, int targetSection, String replacementText, boolean isSlice) throws ParserException {
        Topic topic = null;
        try {
            topic = WikiBase.getDataHandler().lookupTopic(virtualWiki, topicName, false, null);
        }
        catch (DataAccessException e) {
            throw new ParserException(e);
        }
        if (topic == null || topic.getTopicContent() == null) {
            return null;
        }
        ParserInput parserInput = new ParserInput(virtualWiki, topicName);
        parserInput.setContext(context);
        parserInput.setLocale(locale);
        AbstractParser parser = ParserUtil.parserInstance(parserInput);
        String content = null;
        content = isSlice ? parser.parseSlice(parserOutput, topic.getTopicContent(), targetSection) : parser.parseSplice(parserOutput, topic.getTopicContent(), targetSection, replacementText);
        String sectionName = parserOutput.getSectionName();
        return new String[]{sectionName, content};
    }
}

