/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.image;

import com.liferay.portal.image.BaseHook;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.Image;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.NoSuchFileException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileSystemHook
extends BaseHook {
    private File _rootDir = new File(PropsValues.IMAGE_HOOK_FILE_SYSTEM_ROOT_DIR);

    public FileSystemHook() throws IOException {
        FileUtil.mkdirs((File)this._rootDir);
    }

    public void deleteImage(Image image) {
        File file = this.getFile(image.getImageId(), image.getType());
        FileUtil.delete((File)file);
    }

    public byte[] getImageAsBytes(Image image) throws PortalException, SystemException {
        try {
            File file = this.getFile(image.getImageId(), image.getType());
            if (!file.exists()) {
                throw new NoSuchFileException(file.getPath());
            }
            return FileUtil.getBytes((File)file);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public InputStream getImageAsStream(Image image) throws PortalException, SystemException {
        try {
            File file = this.getFile(image.getImageId(), image.getType());
            if (!file.exists()) {
                throw new NoSuchFileException(file.getPath());
            }
            return new FileInputStream(file);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public void updateImage(Image image, String type, byte[] bytes) throws SystemException {
        try {
            File file = this.getFile(image.getImageId(), type);
            FileUtil.write((File)file, (byte[])bytes);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    protected String buildPath(String fileNameFragment) {
        int fileNameFragmentLength = fileNameFragment.length();
        if (fileNameFragmentLength <= 2) {
            return "";
        }
        StringBundler sb = new StringBundler(fileNameFragmentLength / 2 + fileNameFragmentLength);
        int i2 = 0;
        while (i2 < fileNameFragmentLength) {
            if (i2 + 2 < fileNameFragmentLength) {
                sb.append("/");
                sb.append(fileNameFragment.substring(i2, i2 + 2));
            }
            i2 += 2;
        }
        return sb.toString();
    }

    protected File getFile(long imageId, String type) {
        String path = this.buildPath(String.valueOf(imageId));
        return new File(this._rootDir + "/" + path + "/" + imageId + "." + type);
    }
}

