/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.sourceformatter;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.sourceformatter.BaseSourceProcessor;
import com.liferay.util.ContentUtil;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.List;

public class PropertiesSourceProcessor
extends BaseSourceProcessor {
    private String _portalPortalProperties;

    @Override
    protected void format() throws Exception {
        this.formatPortalProperties();
    }

    protected void formatPortalPortalProperties(File file, String fileName) throws Exception {
        StringBundler sb = new StringBundler();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(this._portalPortalProperties));
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if ((line = this.trimLine(line, true)).startsWith("\t")) {
                line = line.replaceFirst("\t", "    ");
            }
            sb.append(line);
            sb.append("\n");
        }
        unsyncBufferedReader.close();
        String newContent = sb.toString();
        if (newContent.endsWith("\n")) {
            newContent = newContent.substring(0, newContent.length() - 1);
        }
        if (this.isAutoFix() && newContent != null && !this._portalPortalProperties.equals(newContent)) {
            fileUtil.write(file, newContent);
            sourceFormatterHelper.printError(fileName, file);
        }
    }

    protected void formatPortalProperties() throws Exception {
        if (portalSource) {
            String portalPortalPropertiesfileName = "portal-impl/src/portal.properties";
            File portalPortalPropertiesFile = new File("./" + portalPortalPropertiesfileName);
            this._portalPortalProperties = fileUtil.read(portalPortalPropertiesFile);
            this.formatPortalPortalProperties(portalPortalPropertiesFile, portalPortalPropertiesfileName);
        } else {
            this._portalPortalProperties = ContentUtil.get((String)"portal.properties");
        }
        String[] excludes = null;
        String[] includes = null;
        if (portalSource) {
            excludes = new String[]{"**\\bin\\**", "**\\classes\\**"};
            includes = new String[]{"**\\portal-ext.properties", "**\\portal-legacy-*.properties"};
        } else {
            excludes = new String[]{};
            includes = new String[]{"**\\portal.properties", "**\\portal-ext.properties"};
        }
        List<String> fileNames = this.getFileNames(excludes, includes);
        for (String fileName : fileNames) {
            File file = new File("./" + fileName);
            fileName = StringUtil.replace((String)fileName, (String)"\\", (String)"/");
            String content = fileUtil.read(file);
            this.formatPortalProperties(fileName, content);
        }
    }

    protected void formatPortalProperties(String fileName, String content) throws IOException {
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(content));
        int lineCount = 0;
        String line = null;
        int previousPos = -1;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            ++lineCount;
            int pos = line.indexOf("=");
            if (pos == -1) continue;
            String property = line.substring(0, pos + 1);
            pos = this._portalPortalProperties.indexOf("    " + (property = property.trim()));
            if (pos == -1) continue;
            if (pos < previousPos) {
                this.processErrorMessage(fileName, "sort " + fileName + " " + lineCount);
            }
            previousPos = pos;
        }
    }
}

