/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.model.AssetCategoryDisplay;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import com.liferay.portlet.asset.service.base.AssetCategoryServiceBaseImpl;
import com.liferay.portlet.asset.service.permission.AssetCategoryPermission;
import com.liferay.util.Autocomplete;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class AssetCategoryServiceImpl
extends AssetCategoryServiceBaseImpl {
    public AssetCategory addCategory(long parentCategoryId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, long vocabularyId, String[] categoryProperties, ServiceContext serviceContext) throws PortalException, SystemException {
        AssetCategoryPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), parentCategoryId, "ADD_CATEGORY");
        return this.assetCategoryLocalService.addCategory(this.getUserId(), parentCategoryId, titleMap, descriptionMap, vocabularyId, categoryProperties, serviceContext);
    }

    public AssetCategory addCategory(String title, long vocabularyId, ServiceContext serviceContext) throws PortalException, SystemException {
        AssetCategoryPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), 0L, "ADD_CATEGORY");
        return this.assetCategoryLocalService.addCategory(this.getUserId(), title, vocabularyId, serviceContext);
    }

    public void deleteCategories(long[] categoryIds) throws PortalException, SystemException {
        this.deleteCategories(categoryIds, null);
    }

    public List<AssetCategory> deleteCategories(long[] categoryIds, ServiceContext serviceContext) throws PortalException, SystemException {
        ArrayList<AssetCategory> failedCategories = new ArrayList<AssetCategory>();
        long[] lArray = categoryIds;
        int n = categoryIds.length;
        int n2 = 0;
        while (n2 < n) {
            long categoryId = lArray[n2];
            try {
                AssetCategoryPermission.check(this.getPermissionChecker(), categoryId, "DELETE");
                this.assetCategoryLocalService.deleteCategory(categoryId);
            }
            catch (PortalException pe) {
                if (serviceContext == null) {
                    return null;
                }
                if (serviceContext.isFailOnPortalException()) {
                    throw pe;
                }
                AssetCategory category = this.assetCategoryPersistence.fetchByPrimaryKey(categoryId);
                if (category == null) {
                    category = this.assetCategoryPersistence.create(categoryId);
                }
                failedCategories.add(category);
            }
            ++n2;
        }
        return failedCategories;
    }

    public void deleteCategory(long categoryId) throws PortalException, SystemException {
        AssetCategoryPermission.check(this.getPermissionChecker(), categoryId, "DELETE");
        this.assetCategoryLocalService.deleteCategory(categoryId);
    }

    public List<AssetCategory> getCategories(String className, long classPK) throws PortalException, SystemException {
        return this.filterCategories(this.assetCategoryLocalService.getCategories(className, classPK));
    }

    public AssetCategory getCategory(long categoryId) throws PortalException, SystemException {
        AssetCategoryPermission.check(this.getPermissionChecker(), categoryId, "VIEW");
        return this.assetCategoryLocalService.getCategory(categoryId);
    }

    public List<AssetCategory> getChildCategories(long parentCategoryId) throws PortalException, SystemException {
        return this.filterCategories(this.assetCategoryLocalService.getChildCategories(parentCategoryId));
    }

    public List<AssetCategory> getChildCategories(long parentCategoryId, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        return this.filterCategories(this.assetCategoryLocalService.getChildCategories(parentCategoryId, start, end, obc));
    }

    public JSONArray getJSONSearch(long groupId, String name, long[] vocabularyIds, int start, int end) throws PortalException, SystemException {
        return this.search(new long[]{groupId}, name, vocabularyIds, start, end);
    }

    public JSONObject getJSONVocabularyCategories(long vocabularyId, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        List<AssetCategory> categories = this.filterCategories(this.assetCategoryLocalService.getVocabularyCategories(vocabularyId, start, end, obc));
        jsonObject.put("categories", this.toJSONArray(categories));
        jsonObject.put("total", categories.size());
        return jsonObject;
    }

    public JSONObject getJSONVocabularyCategories(long groupId, String title, long vocabularyId, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        List<AssetCategory> categories;
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        int page = 0;
        if (end > 0 && start > 0) {
            page = end / (end - start);
        }
        jsonObject.put("page", page);
        int total = 0;
        if (Validator.isNotNull((String)title)) {
            categories = this.searchCategories(new long[]{groupId}, title, new long[]{vocabularyId}, start, end);
            total = categories.size();
        } else {
            categories = this.getVocabularyCategories(vocabularyId, start, end, obc);
            total = this.getVocabularyCategoriesCount(groupId, vocabularyId);
        }
        jsonObject.put("categories", this.toJSONArray(categories));
        jsonObject.put("total", total);
        return jsonObject;
    }

    public List<AssetCategory> getVocabularyCategories(long vocabularyId, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        return this.filterCategories(this.assetCategoryLocalService.getVocabularyCategories(vocabularyId, start, end, obc));
    }

    public List<AssetCategory> getVocabularyCategories(long parentCategoryId, long vocabularyId, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        return this.filterCategories(this.assetCategoryLocalService.getVocabularyCategories(parentCategoryId, vocabularyId, start, end, obc));
    }

    public List<AssetCategory> getVocabularyCategories(long groupId, String name, long vocabularyId, int start, int end, OrderByComparator obc) throws SystemException {
        if (Validator.isNull((String)name)) {
            return this.assetCategoryPersistence.filterFindByG_V(groupId, vocabularyId, start, end, obc);
        }
        return this.assetCategoryPersistence.filterFindByG_LikeN_V(groupId, name, vocabularyId, start, end, obc);
    }

    public int getVocabularyCategoriesCount(long groupId, long vocabularyId) throws SystemException {
        return this.assetCategoryPersistence.filterCountByG_V(groupId, vocabularyId);
    }

    public int getVocabularyCategoriesCount(long groupId, String name, long vocabularyId) throws SystemException {
        if (Validator.isNull((String)name)) {
            return this.assetCategoryPersistence.filterCountByG_V(groupId, vocabularyId);
        }
        return this.assetCategoryPersistence.filterCountByG_LikeN_V(groupId, name, vocabularyId);
    }

    public AssetCategoryDisplay getVocabularyCategoriesDisplay(long vocabularyId, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        List<AssetCategory> categories = this.filterCategories(this.assetCategoryLocalService.getVocabularyCategories(vocabularyId, start, end, obc));
        return new AssetCategoryDisplay(categories, categories.size(), start, end);
    }

    public AssetCategoryDisplay getVocabularyCategoriesDisplay(long groupId, String name, long vocabularyId, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        List<AssetCategory> categories = null;
        int total = 0;
        if (Validator.isNotNull((String)name)) {
            name = CustomSQLUtil.keywords((String)name)[0];
            categories = this.getVocabularyCategories(groupId, name, vocabularyId, start, end, obc);
            total = this.getVocabularyCategoriesCount(groupId, name, vocabularyId);
        } else {
            categories = this.getVocabularyCategories(vocabularyId, start, end, obc);
            total = this.getVocabularyCategoriesCount(groupId, vocabularyId);
        }
        return new AssetCategoryDisplay(categories, total, start, end);
    }

    public List<AssetCategory> getVocabularyRootCategories(long vocabularyId, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        AssetVocabulary vocabulary = this.assetVocabularyLocalService.getVocabulary(vocabularyId);
        return this.getVocabularyRootCategories(vocabulary.getGroupId(), vocabularyId, start, end, obc);
    }

    public List<AssetCategory> getVocabularyRootCategories(long groupId, long vocabularyId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.assetCategoryPersistence.filterFindByG_P_V(groupId, 0L, vocabularyId, start, end, obc);
    }

    public int getVocabularyRootCategoriesCount(long groupId, long vocabularyId) throws SystemException {
        return this.assetCategoryPersistence.filterCountByG_P_V(groupId, 0L, vocabularyId);
    }

    public AssetCategory moveCategory(long categoryId, long parentCategoryId, long vocabularyId, ServiceContext serviceContext) throws PortalException, SystemException {
        AssetCategoryPermission.check(this.getPermissionChecker(), categoryId, "UPDATE");
        return this.assetCategoryLocalService.moveCategory(categoryId, parentCategoryId, vocabularyId, serviceContext);
    }

    public List<AssetCategory> search(long groupId, String keywords, long vocabularyId, int start, int end, OrderByComparator obc) throws SystemException {
        String name = CustomSQLUtil.keywords((String)keywords)[0];
        if (Validator.isNull((String)name)) {
            return this.assetCategoryPersistence.filterFindByG_V(groupId, vocabularyId, start, end, obc);
        }
        return this.assetCategoryPersistence.filterFindByG_LikeN_V(groupId, name, vocabularyId, start, end, obc);
    }

    public JSONArray search(long groupId, String name, String[] categoryProperties, int start, int end) throws PortalException, SystemException {
        List<AssetCategory> categories = this.assetCategoryLocalService.search(groupId, name, categoryProperties, start, end);
        categories = this.filterCategories(categories);
        return Autocomplete.listToJson(categories, (String)"name", (String)"name");
    }

    public JSONArray search(long[] groupIds, String title, long[] vocabularyIds, int start, int end) throws PortalException, SystemException {
        List<AssetCategory> categories = this.searchCategories(groupIds, title, vocabularyIds, start, end);
        return this.toJSONArray(categories);
    }

    public AssetCategory updateCategory(long categoryId, long parentCategoryId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, long vocabularyId, String[] categoryProperties, ServiceContext serviceContext) throws PortalException, SystemException {
        AssetCategoryPermission.check(this.getPermissionChecker(), categoryId, "UPDATE");
        return this.assetCategoryLocalService.updateCategory(this.getUserId(), categoryId, parentCategoryId, titleMap, descriptionMap, vocabularyId, categoryProperties, serviceContext);
    }

    protected SearchContext buildSearchContext(long companyId, long[] groupIds, String title, long[] vocabularyIds, int start, int end) {
        SearchContext searchContext = new SearchContext();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("assetVocabularyIds", vocabularyIds);
        attributes.put("title", title);
        searchContext.setAttributes(attributes);
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setGroupIds(groupIds);
        searchContext.setKeywords(title);
        QueryConfig queryConfig = new QueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        searchContext.setQueryConfig(queryConfig);
        searchContext.setStart(start);
        return searchContext;
    }

    protected List<AssetCategory> filterCategories(List<AssetCategory> categories) throws PortalException, SystemException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        categories = ListUtil.copy(categories);
        Iterator itr = categories.iterator();
        while (itr.hasNext()) {
            AssetCategory category = (AssetCategory)itr.next();
            if (AssetCategoryPermission.contains(permissionChecker, category, "VIEW")) continue;
            itr.remove();
        }
        return categories;
    }

    protected List<AssetCategory> searchCategories(long[] groupIds, String title, long[] vocabularyIds, int start, int end) throws PortalException, SystemException {
        User user = this.getUser();
        SearchContext searchContext = this.buildSearchContext(user.getCompanyId(), groupIds, title, vocabularyIds, start, end);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(AssetCategory.class);
        int i2 = 0;
        while (i2 < 10) {
            Hits hits = indexer.search(searchContext);
            List documents = hits.toList();
            ArrayList<AssetCategory> categories = new ArrayList<AssetCategory>(documents.size());
            for (Document document : documents) {
                long categoryId = GetterUtil.getLong((String)document.get("assetCategoryId"));
                AssetCategory category = AssetCategoryLocalServiceUtil.getCategory((long)categoryId);
                if (category == null) {
                    categories = null;
                    long companyId = GetterUtil.getLong((String)document.get("companyId"));
                    indexer.delete(companyId, document.getUID());
                    continue;
                }
                if (categories == null) continue;
                categories.add(category);
            }
            if (categories != null) {
                return categories;
            }
            ++i2;
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    protected JSONArray toJSONArray(List<AssetCategory> categories) throws PortalException, SystemException {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (AssetCategory category : categories) {
            String categoryJSON = JSONFactoryUtil.looseSerialize((Object)category);
            JSONObject categoryJSONObject = JSONFactoryUtil.createJSONObject((String)categoryJSON);
            ArrayList<String> names = new ArrayList<String>();
            AssetCategory curCategory = category;
            while (curCategory.getParentCategoryId() > 0L) {
                AssetCategory parentCategory = this.getCategory(curCategory.getParentCategoryId());
                names.add(parentCategory.getName());
                names.add(" > ");
                curCategory = parentCategory;
            }
            Collections.reverse(names);
            AssetVocabulary vocabulary = this.assetVocabularyService.getVocabulary(category.getVocabularyId());
            StringBundler sb = new StringBundler(1 + names.size());
            sb.append(vocabulary.getTitleCurrentValue());
            sb.append(names.toArray(new String[names.size()]));
            categoryJSONObject.put("path", sb.toString());
            jsonArray.put(categoryJSONObject);
        }
        return jsonArray;
    }
}

