/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ccpp;

import com.sun.ccpp.AttributeDescriptionImpl;
import com.sun.ccpp.ComponentDescriptionImpl;
import com.sun.ccpp.ComponentImpl;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.ccpp.Attribute;
import javax.ccpp.Component;
import javax.ccpp.Profile;
import javax.ccpp.ProfileDescription;

public class ProfileImpl
implements Profile {
    private HashMap attrsByURI = new HashMap();
    private HashMap attrsByName = new HashMap();
    private HashMap compsByURI = new HashMap();
    private HashMap compsByLocalType = new HashMap();
    private ProfileDescription description = null;

    ProfileImpl() {
    }

    void mergeProfile(Profile other) {
        Iterator i = other.getComponents().iterator();
        while (i.hasNext()) {
            Component otherComp = (Component)i.next();
            ComponentDescriptionImpl compDescImpl = (ComponentDescriptionImpl)otherComp.getDescription();
            URI uri = compDescImpl.getURIObject();
            Component thisComp = this.getComponent(uri);
            if (thisComp == null) {
                thisComp = (ComponentImpl)((ComponentImpl)otherComp).clone();
            } else {
                ((ComponentImpl)thisComp).mergeComponent(otherComp);
            }
            this.addComponent(thisComp);
        }
    }

    void addComponent(Component comp) {
        if (comp == null) {
            return;
        }
        ComponentDescriptionImpl desc = (ComponentDescriptionImpl)comp.getDescription();
        if (desc != null) {
            this.compsByURI.put(desc.getURIObject(), comp);
            this.compsByLocalType.put(desc.getLocalType(), comp);
        }
        this.addAttributes(comp);
    }

    private void addAttributes(Component comp) {
        if (comp == null) {
            return;
        }
        Set attrs = comp.getAttributes();
        Iterator i = attrs.iterator();
        while (i.hasNext()) {
            Attribute attr = (Attribute)i.next();
            AttributeDescriptionImpl desc = (AttributeDescriptionImpl)attr.getDescription();
            if (desc == null) continue;
            this.attrsByURI.put(desc.getURIObject(), attr);
            this.attrsByName.put(desc.getName(), attr);
        }
    }

    void setDescription(ProfileDescription description) {
        this.description = description;
    }

    public Object clone() {
        ProfileImpl clone = new ProfileImpl();
        clone.description = this.description;
        Iterator i = this.getComponents().iterator();
        while (i.hasNext()) {
            clone.addComponent((ComponentImpl)((ComponentImpl)i.next()).clone());
        }
        return clone;
    }

    public Attribute getAttribute(String name) {
        return (Attribute)this.attrsByName.get(name);
    }

    Attribute getAttribute(URI uri) {
        return (Attribute)this.attrsByURI.get(uri);
    }

    public Set getAttributes() {
        return new HashSet(this.attrsByURI.values());
    }

    public Component getComponent(String localType) {
        return (Component)this.compsByLocalType.get(localType);
    }

    Component getComponent(URI uri) {
        return (Component)this.compsByURI.get(uri);
    }

    public Set getComponents() {
        return new HashSet(this.compsByURI.values());
    }

    public ProfileDescription getDescription() {
        return this.description;
    }
}

