/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.tags;

import com.ecyrd.jspwiki.PageLock;
import com.ecyrd.jspwiki.PageManager;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.providers.ProviderException;
import com.ecyrd.jspwiki.tags.WikiTagBase;
import java.io.IOException;
import javax.servlet.http.HttpSession;

public class CheckLockTag
extends WikiTagBase {
    private static final long serialVersionUID = 1L;
    private LockState m_mode;

    public void initTag() {
        super.initTag();
        this.m_mode = LockState.NOTLOCKED;
    }

    public void setMode(String arg) {
        this.m_mode = "locked".equals(arg) ? LockState.LOCKED : ("owned".equals(arg) ? LockState.OWNED : LockState.NOTLOCKED);
    }

    public final int doWikiStartTag() throws IOException, ProviderException {
        WikiEngine engine = this.m_wikiContext.getEngine();
        WikiPage page = this.m_wikiContext.getPage();
        if (page != null) {
            PageManager mgr = engine.getPageManager();
            PageLock lock = mgr.getCurrentLock(page);
            HttpSession session = this.pageContext.getSession();
            PageLock userLock = (PageLock)session.getAttribute("lock-" + page.getName());
            if (lock != null && this.m_mode == LockState.LOCKED && lock != userLock || lock != null && this.m_mode == LockState.OWNED && lock == userLock || lock == null && this.m_mode == LockState.NOTLOCKED) {
                String tid = this.getId();
                if (tid != null && lock != null) {
                    this.pageContext.setAttribute(tid, (Object)lock);
                }
                return 1;
            }
        }
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LockState {
        LOCKED,
        NOTLOCKED,
        OWNED;

    }
}

