/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.shard.advice;

import com.liferay.portal.dao.shard.advice.ShardAdvice;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Shard;
import com.liferay.portal.service.ShardLocalServiceUtil;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class ShardParameterAdvice
implements MethodInterceptor {
    private static Log _log = LogFactoryUtil.getLog(ShardParameterAdvice.class);
    private ShardAdvice _shardAdvice;

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Object[] arguments = methodInvocation.getArguments();
        long companyId = (Long)arguments[0];
        Shard shard = ShardLocalServiceUtil.getShard((String)Company.class.getName(), (long)companyId);
        String shardName = shard.getName();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Setting service to shard " + shardName + " for " + methodInvocation.toString()));
        }
        Object returnValue = null;
        this._shardAdvice.pushCompanyService(shardName);
        try {
            returnValue = methodInvocation.proceed();
        }
        finally {
            this._shardAdvice.popCompanyService();
        }
        return returnValue;
    }

    public void setShardAdvice(ShardAdvice shardAdvice) {
        this._shardAdvice = shardAdvice;
    }
}

