/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_0_12;

import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.model.Role;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import java.util.List;

public class UpgradePermission
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.runSQL("alter table Company add active_ BOOLEAN");
        this.runSQL("update Company set active_ = TRUE");
        this.runSQL("update Role_ set name = 'Site Administrator' where name = 'Community Administrator'");
        this.runSQL("update Role_ set name = 'Site Member' where name = 'Community Member'");
        this.runSQL("update Role_ set name = 'Site Owner' where name = 'Community Owner'");
        this.runSQL("update Role_ set name = 'Organization User' where name = 'Organization Member'");
        List modelActions = ResourceActionsUtil.getModelResourceActions((String)Role.class.getName());
        ResourceActionLocalServiceUtil.checkResourceActions((String)Role.class.getName(), (List)modelActions);
        RoleLocalServiceUtil.checkSystemRoles();
        this.updatePermissions("com.liferay.portlet.bookmarks", true, true);
        this.updatePermissions("com.liferay.portlet.documentlibrary", false, true);
        this.updatePermissions("com.liferay.portlet.imagegallery", true, true);
        this.updatePermissions("com.liferay.portlet.messageboards", true, true);
        this.updatePermissions("com.liferay.portlet.shopping", true, true);
    }

    protected void updatePermissions(String name, boolean community, boolean guest) throws Exception {
        List modelActions = ResourceActionsUtil.getModelResourceActions((String)name);
        ResourceActionLocalServiceUtil.checkResourceActions((String)name, (List)modelActions);
        int scope = 4;
        long actionIdsLong = 1L;
        if (community) {
            ResourcePermissionLocalServiceUtil.addResourcePermissions((String)name, (String)"Site Member", (int)scope, (long)actionIdsLong);
            ResourcePermissionLocalServiceUtil.addResourcePermissions((String)name, (String)"Organization User", (int)scope, (long)actionIdsLong);
        }
        if (guest) {
            ResourcePermissionLocalServiceUtil.addResourcePermissions((String)name, (String)"Guest", (int)scope, (long)actionIdsLong);
        }
        ResourcePermissionLocalServiceUtil.addResourcePermissions((String)name, (String)"Owner", (int)scope, (long)actionIdsLong);
    }
}

