/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.atom;

import com.liferay.portal.kernel.atom.AtomCollectionAdapter;
import com.liferay.portal.kernel.atom.AtomException;
import com.liferay.portal.kernel.atom.AtomRequestContext;
import java.io.InputStream;
import java.util.Date;

public abstract class BaseAtomCollectionAdapter<E>
implements AtomCollectionAdapter<E> {
    @Override
    public void deleteEntry(String resourceName, AtomRequestContext atomRequestContext) throws AtomException {
        try {
            this.doDeleteEntry(resourceName, atomRequestContext);
        }
        catch (Exception e) {
            Class<?> clazz = e.getClass();
            String className = clazz.getSimpleName();
            if (className.startsWith("NoSuch")) {
                throw new AtomException(404);
            }
            throw new AtomException(500, (Throwable)e);
        }
    }

    @Override
    public E getEntry(String resourceName, AtomRequestContext atomRequestContext) throws AtomException {
        try {
            return this.doGetEntry(resourceName, atomRequestContext);
        }
        catch (Exception e) {
            Class<?> clazz = e.getClass();
            String className = clazz.getSimpleName();
            if (className.startsWith("NoSuch")) {
                throw new AtomException(404);
            }
            throw new AtomException(500, (Throwable)e);
        }
    }

    @Override
    public Iterable<E> getFeedEntries(AtomRequestContext atomRequestContext) throws AtomException {
        try {
            return this.doGetFeedEntries(atomRequestContext);
        }
        catch (Exception e) {
            Class<?> clazz = e.getClass();
            String className = clazz.getSimpleName();
            if (className.startsWith("NoSuch")) {
                throw new AtomException(404);
            }
            throw new AtomException(500, (Throwable)e);
        }
    }

    @Override
    public String getMediaContentType(E entry) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getMediaName(E entry) throws AtomException {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getMediaStream(E entry) throws AtomException {
        throw new UnsupportedOperationException();
    }

    @Override
    public E postEntry(String title, String summary, String content, Date date, AtomRequestContext atomRequestContext) throws AtomException {
        try {
            return this.doPostEntry(title, summary, content, date, atomRequestContext);
        }
        catch (Exception e) {
            Class<?> clazz = e.getClass();
            String className = clazz.getSimpleName();
            if (className.startsWith("NoSuch")) {
                throw new AtomException(404);
            }
            throw new AtomException(500, (Throwable)e);
        }
    }

    @Override
    public E postMedia(String mimeType, String slug, InputStream inputStream, AtomRequestContext atomRequestContext) throws AtomException {
        try {
            return this.doPostMedia(mimeType, slug, inputStream, atomRequestContext);
        }
        catch (Exception e) {
            Class<?> clazz = e.getClass();
            String className = clazz.getSimpleName();
            if (className.startsWith("NoSuch")) {
                throw new AtomException(404);
            }
            throw new AtomException(500, (Throwable)e);
        }
    }

    @Override
    public void putEntry(E entry, String title, String summary, String content, Date date, AtomRequestContext atomRequestContext) throws AtomException {
        try {
            this.doPutEntry(entry, title, summary, content, date, atomRequestContext);
        }
        catch (Exception e) {
            Class<?> clazz = e.getClass();
            String className = clazz.getSimpleName();
            if (className.startsWith("NoSuch")) {
                throw new AtomException(404);
            }
            throw new AtomException(500, (Throwable)e);
        }
    }

    @Override
    public void putMedia(E entry, String mimeType, String slug, InputStream inputStream, AtomRequestContext atomRequestContext) throws AtomException {
        try {
            this.doPutMedia(entry, mimeType, slug, inputStream, atomRequestContext);
        }
        catch (Exception e) {
            Class<?> clazz = e.getClass();
            String className = clazz.getSimpleName();
            if (className.startsWith("NoSuch")) {
                throw new AtomException(404);
            }
            throw new AtomException(500, (Throwable)e);
        }
    }

    protected void doDeleteEntry(String resourceName, AtomRequestContext atomRequestContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected abstract E doGetEntry(String var1, AtomRequestContext var2) throws Exception;

    protected abstract Iterable<E> doGetFeedEntries(AtomRequestContext var1) throws Exception;

    protected E doPostEntry(String title, String summary, String content, Date date, AtomRequestContext atomRequestContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected E doPostMedia(String mimeType, String slug, InputStream inputStream, AtomRequestContext atomRequestContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected void doPutEntry(E entry, String title, String summary, String content, Date date, AtomRequestContext atomRequestContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected void doPutMedia(E entry, String mimeType, String slug, InputStream inputStream, AtomRequestContext atomRequestContext) throws Exception {
        throw new UnsupportedOperationException();
    }
}

