/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.lock;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.Lock;
import com.liferay.portal.service.LockLocalServiceUtil;
import java.util.Date;

public class LockProtectedAction<T> {
    private static Log _log = LogFactoryUtil.getLog(LockProtectedAction.class);
    private String _className;
    private String _lockKey;
    private long _retryDelay;
    private T _returnValue;
    private long _timeout;

    public LockProtectedAction(Class<?> clazz, String lockKey, long timeout, long retryDelay) {
        this._className = clazz.getName();
        this._lockKey = lockKey;
        this._timeout = timeout;
        this._retryDelay = retryDelay;
    }

    public T getReturnValue() {
        return this._returnValue;
    }

    public void performAction() throws PortalException, SystemException {
        Lock lock = null;
        while (true) {
            try {
                lock = LockLocalServiceUtil.lock(this._className, this._lockKey, this._lockKey);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn("Unable to acquire lock. Retrying.");
                continue;
            }
            if (lock.isNew()) {
                try {
                    this._returnValue = this.performProtectedAction();
                    break;
                }
                finally {
                    LockLocalServiceUtil.unlock(this._className, this._lockKey, this._lockKey);
                }
            }
            Date createDate = lock.getCreateDate();
            if (System.currentTimeMillis() - createDate.getTime() >= this._timeout) {
                LockLocalServiceUtil.unlock(this._className, this._lockKey, lock.getOwner());
                if (!_log.isWarnEnabled()) continue;
                _log.warn("Removed lock " + lock + " due to timeout");
                continue;
            }
            try {
                Thread.sleep(this._retryDelay);
            }
            catch (InterruptedException ie) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn("Interrupted while waiting to reacquire lock", ie);
            }
        }
    }

    protected T performProtectedAction() throws PortalException, SystemException {
        return null;
    }
}

