/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi;

import aQute.bnd.version.Version;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OSInformation {
    String osnames = null;
    Version osversion = null;
    private static String regexQualifierNotAllowedChars = "[^\\p{Alnum}-_]";
    private static Pattern digitPattern = Pattern.compile("(\\d+).*");

    void convertUnixKernelVersion(String sysPropOsVersion) {
        this.osversion = new Version(0, 0, 0);
        String s = sysPropOsVersion.trim();
        int index = 0;
        do {
            int matchedDigitNumber;
            Matcher matcher;
            if (!(matcher = digitPattern.matcher(s)).matches()) continue;
            String matchedDigit = matcher.group(1);
            try {
                matchedDigitNumber = Integer.parseInt(matchedDigit);
            }
            catch (NumberFormatException e) {
                assert (false);
                break;
            }
            switch (index) {
                case 0: {
                    this.osversion = new Version(matchedDigitNumber, this.osversion.getMinor(), this.osversion.getMicro());
                    break;
                }
                case 1: {
                    this.osversion = new Version(this.osversion.getMajor(), matchedDigitNumber, this.osversion.getMicro());
                    break;
                }
                case 2: {
                    this.osversion = new Version(this.osversion.getMajor(), this.osversion.getMinor(), matchedDigitNumber);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            s = s.substring(matchedDigit.length());
            if (s.length() == 0 || s.charAt(0) != '.') break;
            s = s.substring(1);
            ++index;
        } while (index < 3);
        if (s.length() != 0) {
            String qualifier = s.replaceAll(regexQualifierNotAllowedChars, "_");
            this.osversion = new Version(this.osversion.getMajor(), this.osversion.getMinor(), this.osversion.getMicro(), qualifier);
        }
    }

    public OSInformation() throws IllegalArgumentException {
        String sysPropOsName = System.getProperty("os.name");
        String sysPropOsVersion = System.getProperty("os.version");
        if (sysPropOsName == null || sysPropOsName.length() == 0 || sysPropOsVersion == null || sysPropOsVersion.length() == 0) {
            return;
        }
        if (sysPropOsName.startsWith("Windows")) {
            if (sysPropOsVersion.startsWith("6.2")) {
                this.osversion = new Version(6, 2, 0);
                this.osnames = "Windows8,Windows 8,Win32";
            } else if (sysPropOsVersion.startsWith("6.1")) {
                this.osversion = new Version(6, 1, 0);
                this.osnames = "Windows7,Windows 7,Win32";
            } else if (sysPropOsVersion.startsWith("6.0")) {
                this.osversion = new Version(6, 0, 0);
                this.osnames = "WindowsVista,WinVista,Windows Vista,Win32";
            } else if (sysPropOsVersion.startsWith("5.1")) {
                this.osversion = new Version(5, 1, 0);
                this.osnames = "WindowsXP,WinXP,Windows XP,Win32";
            } else {
                throw new IllegalArgumentException(String.format("Unrecognised or unsupported Windows version while processing ${native_capability} macro: %s version %s. Supported: XP, Vista, Win7, Win8.", sysPropOsName, sysPropOsVersion));
            }
            return;
        }
        if (sysPropOsName.startsWith("Mac OS X")) {
            this.convertUnixKernelVersion(sysPropOsVersion);
            this.osnames = "MacOSX,Mac OS X";
            return;
        }
        if (sysPropOsName.toLowerCase().startsWith("linux")) {
            this.convertUnixKernelVersion(sysPropOsVersion);
            this.osnames = "Linux";
            return;
        }
        if (sysPropOsName.startsWith("Solaris")) {
            this.convertUnixKernelVersion(sysPropOsVersion);
            this.osnames = "Solaris";
            return;
        }
        if (sysPropOsName.startsWith("AIX")) {
            this.convertUnixKernelVersion(sysPropOsVersion);
            this.osnames = "AIX";
            return;
        }
        if (sysPropOsName.startsWith("HP-UX")) {
            this.convertUnixKernelVersion(sysPropOsVersion);
            this.osnames = "HPUX,hp-ux";
            return;
        }
        throw new IllegalArgumentException(String.format("Unrecognised or unsupported OS while processing ${native_capability} macro: %s version %s. Supported: Windows, Mac OS X, Linux, Solaris, AIX, HP-UX.", sysPropOsName, sysPropOsVersion));
    }
}

