/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.verify.VerifyProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class VerifyOracle
extends VerifyProcess {
    private static final int[] _ORIGINAL_DATA_LENGTH_VALUES = new int[]{75, 100, 150, 200, 255, 500, 1000, 1024, 2000, 4000};
    private static Log _log = LogFactoryUtil.getLog(VerifyOracle.class);

    protected void alterVarchar2Columns() throws Exception {
        int buildNumber = this.getBuildNumber();
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select table_name, column_name, data_length from user_tab_columns where data_type = 'VARCHAR2' and char_used = 'B'");
            rs = ps.executeQuery();
            while (rs.next()) {
                String tableName = rs.getString(1);
                if (!this.isPortalTableName(tableName)) continue;
                String columnName = rs.getString(2);
                int dataLength = rs.getInt(3);
                if ((this.isBetweenBuildNumbers(buildNumber, 5209, 6000) || this.isBetweenBuildNumbers(buildNumber, 6005, 6120)) && !ArrayUtil.contains((int[])_ORIGINAL_DATA_LENGTH_VALUES, (int)dataLength)) {
                    dataLength /= 4;
                }
                try {
                    this.runSQL("alter table " + tableName + " modify " + columnName + " varchar2(" + dataLength + " char)");
                }
                catch (SQLException sqle) {
                    if (sqle.getErrorCode() == 1441) {
                        if (!_log.isWarnEnabled()) continue;
                        StringBundler sb = new StringBundler(6);
                        sb.append("Unable to alter length of column ");
                        sb.append(columnName);
                        sb.append(" for table ");
                        sb.append(tableName);
                        sb.append(" because it contains values that are ");
                        sb.append("larger than the new column length");
                        _log.warn((Object)sb.toString());
                        continue;
                    }
                    throw sqle;
                }
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void convertColumnToClob(String tableName, String columnName) throws Exception {
        StringBundler sb;
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block6: {
            block4: {
                block5: {
                    con = null;
                    ps = null;
                    rs = null;
                    try {
                        con = DataAccess.getUpgradeOptimizedConnection();
                        sb = new StringBundler(6);
                        sb.append("select data_type from user_tab_columns where ");
                        sb.append("table_name = '");
                        sb.append(StringUtil.toUpperCase((String)tableName));
                        sb.append("' and column_name = '");
                        sb.append(StringUtil.toUpperCase((String)columnName));
                        sb.append("'");
                        ps = con.prepareStatement(sb.toString());
                        rs = ps.executeQuery();
                        if (rs.next()) break block4;
                        if (!_log.isWarnEnabled()) break block5;
                        sb = new StringBundler(5);
                        sb.append("Column ");
                        sb.append(columnName);
                        sb.append(" in table ");
                        sb.append(tableName);
                        sb.append(" could not be found.");
                        _log.warn((Object)sb.toString());
                    }
                    catch (Throwable throwable) {
                        DataAccess.cleanUp((Connection)con, ps, rs);
                        throw throwable;
                    }
                }
                DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
                return;
            }
            String dataType = rs.getString(1);
            if (!dataType.equals("CLOB")) break block6;
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return;
        }
        this.runSQL("alter table " + tableName + " add temp CLOB");
        sb = new StringBundler(4);
        sb.append("update ");
        sb.append(tableName);
        sb.append(" set temp = ");
        sb.append(columnName);
        this.runSQL(sb.toString());
        sb = new StringBundler(4);
        sb.append("alter table ");
        sb.append(tableName);
        sb.append(" drop column ");
        sb.append(columnName);
        this.runSQL(sb.toString());
        sb = new StringBundler(4);
        sb.append("alter table ");
        sb.append(tableName);
        sb.append(" rename column temp to ");
        sb.append(columnName);
        this.runSQL(sb.toString());
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    @Override
    protected void doVerify() throws Exception {
        DB db = DBFactoryUtil.getDB();
        String dbType = db.getType();
        if (!dbType.equals("oracle")) {
            return;
        }
        this.alterVarchar2Columns();
        this.convertColumnToClob("AssetEntry", "description");
        this.convertColumnToClob("AssetEntry", "summary");
        this.convertColumnToClob("ExpandoColumn", "defaultData");
        this.convertColumnToClob("ExpandoValue", "data_");
        this.convertColumnToClob("JournalArticle", "description");
        this.convertColumnToClob("ShoppingCart", "itemIds");
        this.convertColumnToClob("ShoppingOrder", "comments");
    }

    protected boolean isBetweenBuildNumbers(int buildNumber, int startBuildNumber, int endBuildNumber) {
        return buildNumber >= startBuildNumber && buildNumber < endBuildNumber;
    }
}

