/*
 * Decompiled with CFR 0.152.
 */
package flexjson;

import flexjson.transformer.AbstractTransformer;
import flexjson.transformer.ArrayTransformer;
import flexjson.transformer.BasicDateTransformer;
import flexjson.transformer.BooleanTransformer;
import flexjson.transformer.CharacterTransformer;
import flexjson.transformer.ClassTransformer;
import flexjson.transformer.DefaultCalendarTransformer;
import flexjson.transformer.EnumTransformer;
import flexjson.transformer.HibernateTransformer;
import flexjson.transformer.IterableTransformer;
import flexjson.transformer.MapTransformer;
import flexjson.transformer.NullTransformer;
import flexjson.transformer.NumberTransformer;
import flexjson.transformer.ObjectTransformer;
import flexjson.transformer.StringTransformer;
import flexjson.transformer.TransformerWrapper;
import flexjson.transformer.TypeTransformerMap;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;

public class TransformerUtil {
    private static final TypeTransformerMap defaultTransformers = new TypeTransformerMap(){
        {
            AbstractTransformer transformer = new NullTransformer();
            this.putTransformer(Void.TYPE, new TransformerWrapper(transformer));
            transformer = new ObjectTransformer();
            this.putTransformer(Object.class, new TransformerWrapper(transformer));
            transformer = new ClassTransformer();
            this.putTransformer(Class.class, new TransformerWrapper(transformer));
            transformer = new BooleanTransformer();
            this.putTransformer(Boolean.TYPE, new TransformerWrapper(transformer));
            this.putTransformer(Boolean.class, new TransformerWrapper(transformer));
            transformer = new NumberTransformer();
            this.putTransformer(Number.class, new TransformerWrapper(transformer));
            this.putTransformer(Integer.class, new TransformerWrapper(transformer));
            this.putTransformer(Integer.TYPE, new TransformerWrapper(transformer));
            this.putTransformer(Long.class, new TransformerWrapper(transformer));
            this.putTransformer(Long.TYPE, new TransformerWrapper(transformer));
            this.putTransformer(Double.class, new TransformerWrapper(transformer));
            this.putTransformer(Double.TYPE, new TransformerWrapper(transformer));
            this.putTransformer(Float.class, new TransformerWrapper(transformer));
            this.putTransformer(Float.TYPE, new TransformerWrapper(transformer));
            this.putTransformer(BigDecimal.class, new TransformerWrapper(transformer));
            this.putTransformer(BigInteger.class, new TransformerWrapper(transformer));
            transformer = new StringTransformer();
            this.putTransformer(String.class, new TransformerWrapper(transformer));
            transformer = new CharacterTransformer();
            this.putTransformer(Character.class, new TransformerWrapper(transformer));
            this.putTransformer(Character.TYPE, new TransformerWrapper(transformer));
            transformer = new BasicDateTransformer();
            this.putTransformer(Date.class, new TransformerWrapper(transformer));
            transformer = new DefaultCalendarTransformer();
            this.putTransformer(Calendar.class, new TransformerWrapper(transformer));
            transformer = new EnumTransformer();
            this.putTransformer(Enum.class, new TransformerWrapper(transformer));
            transformer = new IterableTransformer();
            this.putTransformer(Iterable.class, new TransformerWrapper(transformer));
            transformer = new MapTransformer();
            this.putTransformer(Map.class, new TransformerWrapper(transformer));
            transformer = new ArrayTransformer();
            this.putTransformer(Arrays.class, new TransformerWrapper(transformer));
            try {
                Class<?> hibernateProxy = Class.forName("org.hibernate.proxy.HibernateProxy");
                this.putTransformer(hibernateProxy, new TransformerWrapper(new HibernateTransformer()));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            this.locked = true;
        }
    };

    public static TypeTransformerMap getDefaultTypeTransformers() {
        return defaultTransformers;
    }
}

