/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.ui.admin;

import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.event.WikiEngineEvent;
import com.ecyrd.jspwiki.event.WikiEvent;
import com.ecyrd.jspwiki.event.WikiEventListener;
import com.ecyrd.jspwiki.modules.WikiModuleInfo;
import com.ecyrd.jspwiki.ui.admin.AdminBean;
import com.ecyrd.jspwiki.ui.admin.beans.CoreBean;
import com.ecyrd.jspwiki.ui.admin.beans.PluginBean;
import com.ecyrd.jspwiki.ui.admin.beans.SearchManagerBean;
import com.ecyrd.jspwiki.ui.admin.beans.UserBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.log4j.Logger;

public class AdminBeanManager
implements WikiEventListener {
    private WikiEngine m_engine;
    private ArrayList<AdminBean> m_allBeans;
    private MBeanServer m_mbeanServer = null;
    private static Logger log = Logger.getLogger(AdminBeanManager.class);

    public AdminBeanManager(WikiEngine engine) {
        log.info((Object)"Using JDK 1.5 Platform MBeanServer");
        this.m_mbeanServer = MBeanServerFactory15.getServer();
        this.m_engine = engine;
        if (this.m_mbeanServer != null) {
            log.info((Object)this.m_mbeanServer.getClass().getName());
            log.info((Object)this.m_mbeanServer.getDefaultDomain());
        }
        this.m_engine.addWikiEventListener(this);
        this.initialize();
    }

    public void initialize() {
        this.reload();
    }

    private String getJMXTitleString(int title) {
        switch (title) {
            case 1: {
                return "Core";
            }
            case 2: {
                return "Editors";
            }
        }
        return "Unknown";
    }

    private void registerAdminBean(AdminBean ab) {
        try {
            ObjectName name;
            if (ab instanceof DynamicMBean && this.m_mbeanServer != null && !this.m_mbeanServer.isRegistered(name = this.getObjectName(ab))) {
                this.m_mbeanServer.registerMBean(ab, name);
            }
            this.m_allBeans.add(ab);
            log.info((Object)("Registered new admin bean " + ab.getTitle()));
        }
        catch (InstanceAlreadyExistsException e) {
            log.error((Object)"Admin bean already registered to JMX", (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            log.error((Object)"Admin bean cannot be registered to JMX", (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            log.error((Object)"Your admin bean is not very good", (Throwable)e);
        }
        catch (MalformedObjectNameException e) {
            log.error((Object)"Your admin bean name is not very good", (Throwable)e);
        }
        catch (NullPointerException e) {
            log.error((Object)"Evil NPE occurred", (Throwable)e);
        }
    }

    private ObjectName getObjectName(AdminBean ab) throws MalformedObjectNameException {
        String component = this.getJMXTitleString(ab.getType());
        String title = ab.getTitle();
        ObjectName name = new ObjectName("JSPWiki:component=" + component + ",name=" + title);
        return name;
    }

    private void registerBeans(Collection c) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            String abname = ((WikiModuleInfo)i.next()).getAdminBeanClass();
            try {
                if (abname == null || abname.length() <= 0) continue;
                Class<?> abclass = Class.forName(abname);
                AdminBean ab = (AdminBean)abclass.newInstance();
                this.registerAdminBean(ab);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private void reload() {
        this.m_allBeans = new ArrayList();
        try {
            this.registerAdminBean(new CoreBean(this.m_engine));
            this.registerAdminBean(new UserBean(this.m_engine));
            this.registerAdminBean(new SearchManagerBean(this.m_engine));
            this.registerAdminBean(new PluginBean(this.m_engine));
        }
        catch (NotCompliantMBeanException e) {
            e.printStackTrace();
        }
        this.registerBeans(this.m_engine.getEditorManager().modules());
        this.registerBeans(this.m_engine.getPluginManager().modules());
    }

    public List getAllBeans() {
        if (this.m_allBeans == null) {
            this.reload();
        }
        return this.m_allBeans;
    }

    public AdminBean findBean(String id) {
        for (AdminBean ab : this.m_allBeans) {
            if (!ab.getId().equals(id)) continue;
            return ab;
        }
        return null;
    }

    public static int getTypeFromString(String type) {
        if (type.equals("core")) {
            return 1;
        }
        if (type.equals("editors")) {
            return 2;
        }
        return 0;
    }

    public void actionPerformed(WikiEvent event) {
        if (event instanceof WikiEngineEvent && ((WikiEngineEvent)event).getType() == 1) {
            Iterator<AdminBean> i = this.m_allBeans.iterator();
            while (i.hasNext()) {
                try {
                    AdminBean ab = i.next();
                    ObjectName on = this.getObjectName(ab);
                    if (!this.m_mbeanServer.isRegistered(on)) continue;
                    this.m_mbeanServer.unregisterMBean(on);
                    log.info((Object)("Unregistered AdminBean " + ab.getTitle()));
                }
                catch (MalformedObjectNameException e) {
                    log.error((Object)"Malformed object name when unregistering", (Throwable)e);
                }
                catch (InstanceNotFoundException e) {
                    log.error((Object)"Object was registered; yet claims that it's not there", (Throwable)e);
                }
                catch (MBeanRegistrationException e) {
                    log.error((Object)"Registration exception while unregistering", (Throwable)e);
                }
            }
        }
    }

    private static final class MBeanServerFactory15 {
        private MBeanServerFactory15() {
        }

        public static MBeanServer getServer() {
            return ManagementFactory.getPlatformMBeanServer();
        }
    }
}

