/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.social;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.journal.model.JournalFolder;
import com.liferay.portlet.journal.service.permission.JournalFolderPermission;
import com.liferay.portlet.social.model.BaseSocialActivityInterpreter;
import com.liferay.portlet.social.model.SocialActivity;

public class JournalFolderActivityInterpreter
extends BaseSocialActivityInterpreter {
    private static final String[] _CLASS_NAMES = new String[]{JournalFolder.class.getName()};

    public String[] getClassNames() {
        return _CLASS_NAMES;
    }

    protected String getPath(SocialActivity activity, ServiceContext serviceContext) {
        return "/journal/find_folder?folderId=" + activity.getClassPK();
    }

    protected String getTitlePattern(String groupName, SocialActivity activity) {
        int activityType = activity.getType();
        if (activityType == 10007) {
            if (Validator.isNull((String)groupName)) {
                return "activity-journal-folder-move-to-trash";
            }
            return "activity-journal-folder-move-to-trash-in";
        }
        if (activityType == 10008) {
            if (Validator.isNull((String)groupName)) {
                return "activity-journal-folder-restore-from-trash";
            }
            return "activity-journal-folder-restore-from-trash-in";
        }
        return null;
    }

    protected boolean hasPermissions(PermissionChecker permissionChecker, SocialActivity activity, String actionId, ServiceContext serviceContext) throws Exception {
        return JournalFolderPermission.contains(permissionChecker, activity.getGroupId(), activity.getClassPK(), actionId);
    }
}

