/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.filter;

import com.browseengine.bobo.api.BoboIndexReader;
import com.browseengine.bobo.docidset.EmptyDocIdSet;
import com.browseengine.bobo.docidset.RandomAccessDocIdSet;
import com.browseengine.bobo.facets.data.MultiValueFacetDataCache;
import com.browseengine.bobo.facets.filter.FacetFilter;
import com.browseengine.bobo.facets.filter.RandomAccessFilter;
import com.browseengine.bobo.facets.range.MultiDataCacheBuilder;
import com.browseengine.bobo.util.BigNestedIntArray;
import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;

public class MultiValueFacetFilter
extends RandomAccessFilter {
    private static final long serialVersionUID = 1L;
    private final String _val;
    private final MultiDataCacheBuilder multiDataCacheBuilder;

    public MultiValueFacetFilter(MultiDataCacheBuilder multiDataCacheBuilder, String val) {
        this.multiDataCacheBuilder = multiDataCacheBuilder;
        this._val = val;
    }

    @Override
    public double getFacetSelectivity(BoboIndexReader reader) {
        double selectivity = 0.0;
        MultiValueFacetDataCache dataCache = this.multiDataCacheBuilder.build(reader);
        int idx = dataCache.valArray.indexOf(this._val);
        if (idx < 0) {
            return 0.0;
        }
        int freq = dataCache.freqs[idx];
        int total = reader.maxDoc();
        selectivity = (double)freq / (double)total;
        return selectivity;
    }

    @Override
    public RandomAccessDocIdSet getRandomAccessDocIdSet(BoboIndexReader reader) throws IOException {
        final MultiValueFacetDataCache dataCache = this.multiDataCacheBuilder.build(reader);
        final int index = dataCache.valArray.indexOf(this._val);
        final BigNestedIntArray nestedArray = dataCache._nestedArray;
        if (index < 0) {
            return EmptyDocIdSet.getInstance();
        }
        return new RandomAccessDocIdSet(){

            public DocIdSetIterator iterator() {
                return new MultiValueFacetDocIdSetIterator(dataCache, index);
            }

            @Override
            public final boolean get(int docId) {
                return nestedArray.contains(docId, index);
            }
        };
    }

    public static final class MultiValueFacetDocIdSetIterator
    extends FacetFilter.FacetDocIdSetIterator {
        private final BigNestedIntArray _nestedArray;

        public MultiValueFacetDocIdSetIterator(MultiValueFacetDataCache dataCache, int index) {
            super(dataCache, index);
            this._nestedArray = dataCache._nestedArray;
        }

        @Override
        public final int nextDoc() throws IOException {
            this._doc = this._doc < this._maxID ? this._nestedArray.findValue(this._index, this._doc + 1, this._maxID) : Integer.MAX_VALUE;
            return this._doc;
        }

        @Override
        public final int advance(int id) throws IOException {
            if (this._doc < id) {
                this._doc = id <= this._maxID ? this._nestedArray.findValue(this._index, id, this._maxID) : Integer.MAX_VALUE;
                return this._doc;
            }
            return this.nextDoc();
        }
    }
}

