/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.util;

import com.ecyrd.jspwiki.WikiException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;

public final class ClassUtil {
    private static final Logger log = Logger.getLogger(ClassUtil.class);
    public static final String MAPPINGS = "/ini/classmappings.xml";
    private static Map<String, String> c_classMappings = new Hashtable<String, String>();

    private ClassUtil() {
    }

    public static Class findClass(List packages, String className) throws ClassNotFoundException {
        ClassLoader loader = ClassUtil.class.getClassLoader();
        try {
            return loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            for (String packageName : packages) {
                try {
                    return loader.loadClass(packageName + "." + className);
                }
                catch (ClassNotFoundException ex) {
                }
            }
            throw new ClassNotFoundException("Class '" + className + "' not found in search path!");
        }
    }

    public static Class findClass(String packageName, String className) throws ClassNotFoundException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(packageName);
        return ClassUtil.findClass(list, className);
    }

    public static Object getMappedObject(String requestedClass) throws WikiException {
        Object[] initargs = new Object[]{};
        return ClassUtil.getMappedObject(requestedClass, initargs);
    }

    public static Object getMappedObject(String requestedClass, Object arg1) throws WikiException {
        Object[] initargs = new Object[]{arg1};
        return ClassUtil.getMappedObject(requestedClass, initargs);
    }

    public static Object getMappedObject(String requestedClass, Object arg1, Object arg2) throws WikiException {
        Object[] initargs = new Object[]{arg1, arg2};
        return ClassUtil.getMappedObject(requestedClass, initargs);
    }

    public static Object getMappedObject(String requestedClass, Object[] initargs) throws WikiException {
        try {
            Class cl = ClassUtil.getMappedClass(requestedClass);
            Constructor<?>[] ctors = cl.getConstructors();
            for (int c = 0; c < ctors.length; ++c) {
                Class<?>[] params = ctors[c].getParameterTypes();
                if (params.length != initargs.length) continue;
                for (int arg = 0; arg < initargs.length; ++arg) {
                    if (!params[arg].isAssignableFrom(initargs[arg].getClass())) continue;
                    return ctors[c].newInstance(initargs);
                }
            }
            Object o = cl.newInstance();
            return o;
        }
        catch (InstantiationException e) {
            log.info((Object)("Cannot instantiate requested class " + requestedClass), (Throwable)e);
            throw new WikiException("Failed to instantiate class " + requestedClass, e);
        }
        catch (IllegalAccessException e) {
            log.info((Object)("Cannot access requested class " + requestedClass), (Throwable)e);
            throw new WikiException("Failed to instantiate class " + requestedClass, e);
        }
        catch (IllegalArgumentException e) {
            log.info((Object)"Illegal arguments when constructing new object", (Throwable)e);
            throw new WikiException("Failed to instantiate class " + requestedClass, e);
        }
        catch (InvocationTargetException e) {
            log.info((Object)("You tried to instantiate an abstract class " + requestedClass), (Throwable)e);
            throw new WikiException("Failed to instantiate class " + requestedClass, e);
        }
    }

    private static Class getMappedClass(String requestedClass) throws WikiException {
        String mappedClass = c_classMappings.get(requestedClass);
        if (mappedClass == null) {
            mappedClass = requestedClass;
        }
        try {
            Class<?> cl = Class.forName(mappedClass);
            return cl;
        }
        catch (ClassNotFoundException e) {
            log.info((Object)"Cannot find requested class", (Throwable)e);
            throw new WikiException("Failed to instantiate class " + requestedClass, e);
        }
    }

    static {
        try {
            InputStream is = ClassUtil.class.getResourceAsStream(MAPPINGS);
            if (is != null) {
                Document doc = new SAXBuilder().build(is);
                XPath xpath = XPath.newInstance((String)"/classmappings/mapping");
                List nodes = xpath.selectNodes((Object)doc);
                for (Element f : nodes) {
                    String key = f.getChildText("requestedClass");
                    String className = f.getChildText("mappedClass");
                    c_classMappings.put(key, className);
                    log.debug((Object)("Mapped class '" + key + "' to class '" + className + "'"));
                }
            } else {
                log.info((Object)"Didn't find class mapping document in /ini/classmappings.xml");
            }
        }
        catch (Exception ex) {
            log.error((Object)"Unable to parse mappings document!", (Throwable)ex);
        }
    }
}

