/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.expressions.SQLUpdateStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.DatasourceCallQueryMechanism;
import org.eclipse.persistence.internal.queries.StatementQueryMechanism;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.queries.ScrollableCursorPolicy;
import org.eclipse.persistence.queries.WriteObjectQuery;

public class CallQueryMechanism
extends DatasourceCallQueryMechanism {
    public CallQueryMechanism(DatabaseQuery query) {
        super(query);
    }

    public CallQueryMechanism(DatabaseQuery query, DatabaseCall call) {
        super(query, call);
        call.setIsFieldMatchingRequired(true);
    }

    public DatabaseCall getDatabaseCall() {
        return (DatabaseCall)this.call;
    }

    public void prepareCall() throws QueryException {
        DatabaseQuery query = this.getQuery();
        AbstractSession executionSession = query.getExecutionSession();
        if (this.hasMultipleCalls()) {
            if (this.getQuery().shouldCloneCall()) {
                this.calls = (Vector)this.getCalls().clone();
            }
            Enumeration callsEnum = this.getCalls().elements();
            while (callsEnum.hasMoreElements()) {
                DatabaseCall call = (DatabaseCall)callsEnum.nextElement();
                if (!query.shouldIgnoreBindAllParameters()) {
                    call.setUsesBinding(query.shouldBindAllParameters());
                }
                if (!query.shouldIgnoreCacheStatement()) {
                    call.setShouldCacheStatement(query.shouldCacheStatement());
                }
                call.setQueryTimeout(query.getQueryTimeout());
                if (query.isNativeConnectionRequired()) {
                    call.setIsNativeConnectionRequired(true);
                }
                if (query.isReadQuery()) {
                    ReadQuery readQuery = (ReadQuery)query;
                    if (!call.shouldIgnoreFirstRowMaxResultsSettings()) {
                        call.setMaxRows(readQuery.getMaxRows());
                        if (readQuery.getFirstResult() != 0) {
                            call.setFirstResult(readQuery.getFirstResult());
                            call.setIsResultSetScrollable(true);
                            call.setResultSetType(1004);
                            call.setResultSetConcurrency(1007);
                        }
                    }
                    call.setResultSetFetchSize(readQuery.getFetchSize());
                }
                call.prepare(executionSession);
            }
        } else if (this.getCall() != null) {
            if (this.getQuery().shouldCloneCall()) {
                this.call = (DatabaseCall)this.getDatabaseCall().clone();
                this.setCall(this.call);
            }
            DatabaseCall call = this.getDatabaseCall();
            if (!query.shouldIgnoreBindAllParameters()) {
                call.setUsesBinding(query.shouldBindAllParameters());
            }
            if (!query.shouldIgnoreCacheStatement()) {
                call.setShouldCacheStatement(query.shouldCacheStatement());
            }
            call.setQueryTimeout(query.getQueryTimeout());
            if (query.isNativeConnectionRequired()) {
                call.setIsNativeConnectionRequired(true);
            }
            if (query.isReadQuery()) {
                ReadQuery readQuery = (ReadQuery)query;
                if (!call.shouldIgnoreFirstRowMaxResultsSettings()) {
                    call.setMaxRows(readQuery.getMaxRows());
                    if (readQuery.getFirstResult() != 0) {
                        call.setFirstResult(readQuery.getFirstResult());
                        call.setIsResultSetScrollable(true);
                        call.setResultSetType(1004);
                        call.setResultSetConcurrency(1007);
                    }
                }
                call.setResultSetFetchSize(((ReadQuery)query).getFetchSize());
            }
            call.prepare(executionSession);
        }
    }

    public void prepareCursorSelectAllRows() throws QueryException {
        this.getCall().returnCursor();
        DatabaseQuery query = this.getQuery();
        ContainerPolicy cp = query.isReadAllQuery() ? ((ReadAllQuery)query).getContainerPolicy() : ((DataReadQuery)query).getContainerPolicy();
        if (cp.isScrollableCursorPolicy()) {
            ScrollableCursorPolicy scp = (ScrollableCursorPolicy)cp;
            DatabaseCall call = this.getDatabaseCall();
            call.setIsResultSetScrollable(true);
            call.setResultSetType(scp.getResultSetType());
            call.setResultSetConcurrency(scp.getResultSetConcurrency());
            if (((ReadQuery)this.getQuery()).getFetchSize() == 0) {
                call.setResultSetFetchSize(scp.getPageSize());
            }
        }
        if (this.getQuery().isReportQuery()) {
            this.prepareReportQueryItems();
        }
        this.prepareCall();
    }

    public void prepareDeleteAll() {
        if (this.hasMultipleCalls()) {
            Enumeration callsEnum = this.getCalls().elements();
            while (callsEnum.hasMoreElements()) {
                DatabaseCall call = (DatabaseCall)callsEnum.nextElement();
                call.returnNothing();
                if (!this.getQuery().getDescriptor().usesOptimisticLocking()) continue;
                call.setHasOptimisticLock(true);
            }
        } else {
            this.getCall().returnNothing();
            if (this.getQuery().getDescriptor().usesOptimisticLocking()) {
                this.getDatabaseCall().setHasOptimisticLock(true);
            }
        }
        this.prepareCall();
    }

    public void prepareDeleteObject() {
        if (this.hasMultipleCalls()) {
            Enumeration callsEnum = this.getCalls().elements();
            while (callsEnum.hasMoreElements()) {
                DatabaseCall call = (DatabaseCall)callsEnum.nextElement();
                call.returnNothing();
                if (!this.getQuery().getDescriptor().usesOptimisticLocking()) continue;
                call.setHasOptimisticLock(true);
            }
        } else {
            this.getCall().returnNothing();
            if (this.getQuery().getDescriptor().usesOptimisticLocking()) {
                this.getDatabaseCall().setHasOptimisticLock(true);
            }
        }
        this.prepareCall();
    }

    public void prepareDoesExist(DatabaseField field) {
        this.getCall().returnOneRow();
        NonSynchronizedVector fields = NonSynchronizedVector.newInstance(1);
        ((Vector)fields).addElement(field);
        this.getDatabaseCall().setFields(fields);
        this.prepareCall();
    }

    public void prepareExecuteSelect() {
        if (this.hasMultipleCalls()) {
            Enumeration callsEnum = this.getCalls().elements();
            while (callsEnum.hasMoreElements()) {
                DatabaseCall databseCall = (DatabaseCall)callsEnum.nextElement();
                databseCall.returnManyRows();
                databseCall.setIsFieldMatchingRequired(this.isCallQueryMechanism());
            }
        } else {
            DatabaseCall call = this.getDatabaseCall();
            call.returnManyRows();
            call.setIsFieldMatchingRequired(this.isCallQueryMechanism());
        }
        this.prepareCall();
    }

    public void prepareSelectAllRows() {
        if (this.hasMultipleCalls()) {
            Enumeration callsEnum = this.getCalls().elements();
            while (callsEnum.hasMoreElements()) {
                DatabaseCall call = (DatabaseCall)callsEnum.nextElement();
                call.returnManyRows();
                if (!this.isCallQueryMechanism()) continue;
                call.setIsFieldMatchingRequired(true);
                call.setFields(((ObjectLevelReadQuery)this.getQuery()).getSelectionFields());
                this.prepareJoining((ObjectLevelReadQuery)this.getQuery());
            }
        } else {
            this.getCall().returnManyRows();
            if (this.isCallQueryMechanism()) {
                DatabaseCall call = this.getDatabaseCall();
                call.setIsFieldMatchingRequired(true);
                call.setFields(((ObjectLevelReadQuery)this.getQuery()).getSelectionFields());
                this.prepareJoining((ObjectLevelReadQuery)this.getQuery());
            }
        }
        this.prepareCall();
    }

    protected void prepareJoining(ObjectLevelReadQuery query) {
        if (query.hasJoining()) {
            query.getJoinedAttributeManager().computeJoiningMappingIndexes(true, this.getSession(), 0);
        }
    }

    public void prepareSelectOneRow() {
        if (this.hasMultipleCalls()) {
            Enumeration callsEnum = this.getCalls().elements();
            while (callsEnum.hasMoreElements()) {
                DatabaseCall call = (DatabaseCall)callsEnum.nextElement();
                call.returnOneRow();
                if (!this.isCallQueryMechanism()) continue;
                call.setIsFieldMatchingRequired(true);
                call.setFields(((ObjectLevelReadQuery)this.getQuery()).getSelectionFields());
                this.prepareJoining((ObjectLevelReadQuery)this.getQuery());
            }
        } else {
            this.getCall().returnOneRow();
            if (this.isCallQueryMechanism()) {
                DatabaseCall call = this.getDatabaseCall();
                call.setIsFieldMatchingRequired(true);
                call.setFields(((ObjectLevelReadQuery)this.getQuery()).getSelectionFields());
                this.prepareJoining((ObjectLevelReadQuery)this.getQuery());
            }
        }
        this.prepareCall();
    }

    public void prepareUpdateObject() {
        if (this.hasMultipleCalls()) {
            int size = this.calls.size();
            for (int index = 0; index < size; ++index) {
                DatabaseCall call = (DatabaseCall)this.calls.get(index);
                if (!call.isReturnSet()) {
                    call.returnNothing();
                }
                if (!this.query.getDescriptor().usesOptimisticLocking()) continue;
                call.setHasOptimisticLock(true);
            }
        } else if (this.call != null) {
            if (!this.call.isReturnSet()) {
                this.call.returnNothing();
            }
            if (this.query.getDescriptor().usesOptimisticLocking()) {
                ((DatabaseCall)this.call).setHasOptimisticLock(true);
            }
        }
        this.prepareCall();
    }

    public void setCallHasCustomSQLArguments() {
        if (this.hasMultipleCalls()) {
            Enumeration callsEnum = this.getCalls().elements();
            while (callsEnum.hasMoreElements()) {
                DatabaseCall databseCall = (DatabaseCall)callsEnum.nextElement();
                if (!databseCall.isSQLCall()) continue;
                ((SQLCall)databseCall).setHasCustomSQLArguments(true);
            }
        } else if (this.getCall().isSQLCall()) {
            ((SQLCall)this.getCall()).setHasCustomSQLArguments(true);
        }
    }

    protected void updateForeignKeyFieldAfterInsert(WriteObjectQuery writeQuery) {
        Enumeration<DatabaseTable> tablesEnum = this.getDescriptor().getTables().elements();
        while (tablesEnum.hasMoreElements()) {
            DatabaseTable table = tablesEnum.nextElement();
            SQLUpdateStatement updateStatement = new SQLUpdateStatement();
            updateStatement.setModifyRow(this.getDescriptor().getObjectBuilder().buildRowForUpdate(writeQuery));
            updateStatement.setTranslationRow(this.getTranslationRow());
            updateStatement.setTable(table);
            updateStatement.setWhereClause(this.getDescriptor().getObjectBuilder().buildPrimaryKeyExpression(table));
            StatementQueryMechanism updateMechanism = new StatementQueryMechanism((DatabaseQuery)writeQuery, updateStatement);
            writeQuery.setModifyRow(updateStatement.getModifyRow());
            updateMechanism.updateObject();
        }
    }
}

