/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.portletconfiguration.action;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.ConfigurationAction;
import com.liferay.portal.kernel.portlet.ResourceServingConfigurationAction;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portlet.portletconfiguration.action.ActionUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditConfigurationAction
extends PortletAction {
    private static Log _log = LogFactoryUtil.getLog(EditConfigurationAction.class);

    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        Portlet portlet = null;
        try {
            portlet = ActionUtil.getPortlet((PortletRequest)actionRequest);
        }
        catch (PrincipalException principalException) {
            SessionErrors.add((PortletRequest)actionRequest, (String)PrincipalException.class.getName());
            this.setForward((PortletRequest)actionRequest, "portlet.portlet_configuration.error");
            return;
        }
        actionRequest = ActionUtil.getWrappedActionRequest(actionRequest, null);
        ConfigurationAction configurationAction = this.getConfigurationAction(portlet);
        if (configurationAction == null) {
            return;
        }
        configurationAction.processAction(portletConfig, actionRequest, actionResponse);
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        Portlet portlet = null;
        try {
            portlet = ActionUtil.getPortlet((PortletRequest)renderRequest);
        }
        catch (PrincipalException principalException) {
            SessionErrors.add((PortletRequest)renderRequest, (String)PrincipalException.class.getName());
            return actionMapping.findForward("portlet.portlet_configuration.error");
        }
        renderRequest = ActionUtil.getWrappedRenderRequest(renderRequest, null);
        renderResponse.setTitle(ActionUtil.getTitle(portlet, renderRequest));
        ConfigurationAction configurationAction = this.getConfigurationAction(portlet);
        if (configurationAction != null) {
            String path = configurationAction.render(portletConfig, renderRequest, renderResponse);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Configuration action returned render path " + path));
            }
            if (Validator.isNotNull((String)path)) {
                renderRequest.setAttribute("CONFIGURATION_ACTION_PATH", (Object)path);
            } else {
                _log.error((Object)"Configuration action returned a null path");
            }
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.portlet_configuration.edit_configuration"));
    }

    @Override
    public void serveResource(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        Portlet portlet = null;
        try {
            portlet = ActionUtil.getPortlet((PortletRequest)resourceRequest);
        }
        catch (PrincipalException principalException) {
            return;
        }
        resourceRequest = ActionUtil.getWrappedResourceRequest(resourceRequest, null);
        ResourceServingConfigurationAction resourceServingConfigurationAction = (ResourceServingConfigurationAction)this.getConfigurationAction(portlet);
        if (resourceServingConfigurationAction == null) {
            return;
        }
        resourceServingConfigurationAction.serveResource(portletConfig, resourceRequest, resourceResponse);
    }

    protected ConfigurationAction getConfigurationAction(Portlet portlet) throws Exception {
        if (portlet == null) {
            return null;
        }
        ConfigurationAction configurationAction = portlet.getConfigurationActionInstance();
        if (configurationAction == null) {
            _log.error((Object)("Configuration action for portlet " + portlet.getPortletId() + " is null"));
        }
        return configurationAction;
    }
}

